/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.jcajce;

import java.security.Provider;
import org.bouncycastle.shaded.bcpg.AEADEncDataPacket;
import org.bouncycastle.shaded.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.shaded.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPSessionKey;
import org.bouncycastle.shaded.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.shaded.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.shaded.openpgp.operator.jcajce.OperatorHelper;

public class JceSessionKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public SessionKeyDataDecryptorFactory build(PGPSessionKey pGPSessionKey) {
        return new JceSessionKeyDataDecryptorFactory(this.helper, pGPSessionKey);
    }

    private static class JceSessionKeyDataDecryptorFactory
    implements SessionKeyDataDecryptorFactory {
        private final OperatorHelper helper;
        private final JceAEADUtil aeadHelper;
        private final PGPSessionKey sessionKey;

        public JceSessionKeyDataDecryptorFactory(OperatorHelper operatorHelper, PGPSessionKey pGPSessionKey) {
            this.helper = operatorHelper;
            this.aeadHelper = new JceAEADUtil(operatorHelper);
            this.sessionKey = pGPSessionKey;
        }

        @Override
        public PGPSessionKey getSessionKey() {
            return this.sessionKey;
        }

        @Override
        public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
            return this.helper.createDataDecryptor(bl, n, byArray);
        }

        @Override
        public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
            return this.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
        }

        @Override
        public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
            return this.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
        }
    }
}

