/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import org.bouncycastle.shaded.bcpg.AEADEncDataPacket;
import org.bouncycastle.shaded.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.shaded.crypto.BlockCipher;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPSessionKey;
import org.bouncycastle.shaded.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.shaded.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.shaded.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcUtil;

public class BcSessionKeyDataDecryptorFactory
implements SessionKeyDataDecryptorFactory {
    private final PGPSessionKey sessionKey;

    public BcSessionKeyDataDecryptorFactory(PGPSessionKey pGPSessionKey) {
        this.sessionKey = pGPSessionKey;
    }

    @Override
    public PGPSessionKey getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    @Override
    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

