/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.jcajce.provider.symmetric;

import org.bouncycastle.shaded.crypto.CipherKeyGenerator;
import org.bouncycastle.shaded.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle.shaded.jcajce.provider.util.AlgorithmProvider;

public final class SipHash128 {
    private SipHash128() {
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SipHash128", 128, new CipherKeyGenerator());
        }
    }

    public static class Mac24
    extends BaseMac {
        public Mac24() {
            super(new org.bouncycastle.shaded.crypto.macs.SipHash128());
        }
    }

    public static class Mac48
    extends BaseMac {
        public Mac48() {
            super(new org.bouncycastle.shaded.crypto.macs.SipHash128(4, 8));
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = SipHash128.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Mac.SIPHASH128-2-4", PREFIX + "$Mac24");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.SIPHASH128", "SIPHASH128-2-4");
            configurableProvider.addAlgorithm("Mac.SIPHASH128-4-8", PREFIX + "$Mac48");
            configurableProvider.addAlgorithm("KeyGenerator.SIPHASH128", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator.SIPHASH128-2-4", "SIPHASH128");
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator.SIPHASH128-4-8", "SIPHASH128");
        }
    }
}

