/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml;

import com.mulesoft.modules.cryptography.api.jce.config.JceAsymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.jce.config.JceKeyInfo;
import com.mulesoft.modules.cryptography.api.jce.config.JceSymmetricKeyInfo;
import com.mulesoft.modules.cryptography.api.xml.config.EphemeralKeyInfo;
import com.mulesoft.modules.cryptography.api.xml.config.XmlCanonicalizationAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlEncryptionAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignatureType;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.errors.DecryptionErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.EncryptionErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.ParametersErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.SignatureErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.ValidationErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.jce.config.JceConfiguration;
import com.mulesoft.modules.cryptography.internal.jce.config.JceKeySelection;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlAsymmetricKeyImpl;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlKeyImpl;
import com.mulesoft.modules.cryptography.internal.xml.impl.XmlSymmetricKeyImpl;
import java.io.InputStream;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class XmlOperations {
    @MediaType(value="application/xml")
    @Throws(value={EncryptionErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream xmlEncrypt(@Config JceConfiguration config, @Content InputStream content, @Optional(defaultValue="AES_CBC") XmlEncryptionAlgorithm algorithm, @Optional String elementPath, @Optional(defaultValue="true") @Summary(value="Encrypt the XML element or its content, if false the whole XML element is encrypted.") boolean encryptContent, @ParameterGroup(name="Key selection") JceKeySelection keySelection, @ParameterGroup(name="Ephemeral key") EphemeralKeyInfo ephemeralKeyInfo) {
        return XmlOperations.createKeyImplFor(config, keySelection.getKeyInfo(config), ephemeralKeyInfo).encrypt(content, algorithm, elementPath, encryptContent);
    }

    @MediaType(value="application/xml")
    @Throws(value={DecryptionErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream xmlDecrypt(@Config JceConfiguration config, @Content @Optional(defaultValue="#[payload]") InputStream content, @Optional String elementPath, @ParameterGroup(name="Key selection") JceKeySelection keySelection) {
        return XmlOperations.createKeyImplFor(config, keySelection.getKeyInfo(config)).decrypt(content, elementPath);
    }

    @MediaType(value="application/xml")
    @Throws(value={SignatureErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public InputStream xmlSign(@Config JceConfiguration config, @Content InputStream content, @Optional(defaultValue="SHA256") XmlSignDigestAlgorithm digestAlgorithm, @Optional(defaultValue="EXCLUSIVE") XmlCanonicalizationAlgorithm canonicalizationAlgorithm, @Optional(defaultValue="ENVELOPED") XmlSignatureType type, @Optional String elementPath, @ParameterGroup(name="Key selection") JceKeySelection keySelection) {
        return XmlOperations.createKeyImplFor(config, keySelection.getKeyInfo(config)).sign(content, digestAlgorithm, canonicalizationAlgorithm, type, elementPath);
    }

    @Validator
    @Throws(value={ValidationErrorTypeProvider.class, ParametersErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void xmlValidate(@Config JceConfiguration config, @Content InputStream content, @Optional String elementPath, @ParameterGroup(name="Key selection") JceKeySelection keySelection, @Optional @Summary(value="Use inline defined certificate if found") boolean useInlineCertificateIfPresent) {
        boolean isVerified = XmlOperations.createValidatingKeyImplFor(config, keySelection.getKeyInfo(config), useInlineCertificateIfPresent).validate(content, elementPath);
        if (!isVerified) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"XML signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION);
        }
    }

    private static XmlKeyImpl createValidatingKeyImplFor(JceConfiguration config, JceKeyInfo keyInfo, boolean useCertificate) {
        if (keyInfo.isSymmetric()) {
            return new XmlSymmetricKeyImpl(config, (JceSymmetricKeyInfo)keyInfo);
        }
        return new XmlAsymmetricKeyImpl(config, (JceAsymmetricKeyInfo)keyInfo, useCertificate);
    }

    private static XmlKeyImpl createKeyImplFor(JceConfiguration config, JceKeyInfo keyInfo) {
        return XmlOperations.createKeyImplFor(config, keyInfo, null);
    }

    private static XmlKeyImpl createKeyImplFor(JceConfiguration config, JceKeyInfo keyInfo, EphemeralKeyInfo ephemeralKeyInfo) {
        if (keyInfo.isSymmetric()) {
            return new XmlSymmetricKeyImpl(config, (JceSymmetricKeyInfo)keyInfo);
        }
        return new XmlAsymmetricKeyImpl(config, (JceAsymmetricKeyInfo)keyInfo, ephemeralKeyInfo);
    }
}

