/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.PgpEncrypter;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpAsymmetricKeyIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPObjectFactory;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPSecretKey;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRing;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpKeystore {
    private Map<Long, PGPPublicKey> publicKeyMap = new HashMap<Long, PGPPublicKey>();
    private Map<Long, PGPSecretKey> privateKeyMap = new HashMap<Long, PGPSecretKey>();
    private Map<String, Long> principalMap = new HashMap<String, Long>();
    private Map<Long, String> fingerprintToPrincipalMap;
    private Map<Long, String> passPhrasesMap = new HashMap<Long, String>();

    public PgpKeystore(String publicKeyring, String privateKeyring) {
        this.fingerprintToPrincipalMap = new HashMap<Long, String>();
        if (publicKeyring != null) {
            this.readPublicKeys(publicKeyring);
        }
        if (privateKeyring != null) {
            this.readPrivateKeys(privateKeyring);
        }
        this.reversePrincipalMap();
    }

    private void reversePrincipalMap() {
        this.principalMap.forEach((principal, fingerprint) -> this.fingerprintToPrincipalMap.put((Long)fingerprint, (String)principal));
    }

    public void registerPassphrase(Long fingerprint, String passphrase) {
        this.getPrivateKey(fingerprint);
        this.passPhrasesMap.put(fingerprint, passphrase);
    }

    public String getPrincipalFromFingerprint(Long fingerprint) {
        return this.fingerprintToPrincipalMap.get(fingerprint);
    }

    public Long getFingerprintFromPrincipal(String principal) {
        return this.principalMap.get(principal);
    }

    public Long getFingerprintFromIdentifier(PgpAsymmetricKeyIdentifier keyIdentifier) {
        return keyIdentifier.getFingerprint(this);
    }

    public PGPPublicKey getPublicKey(Long fingerprint) {
        PGPPublicKey key = this.publicKeyMap.get(fingerprint);
        if (key == null) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Public key with fingerprint '%s' was not found", PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return key;
    }

    public boolean hasPrivateKey(Long fingerprint) {
        return this.privateKeyMap.get(fingerprint) != null;
    }

    public PGPSecretKey getPrivateKey(Long fingerprint) {
        PGPSecretKey key = this.privateKeyMap.get(fingerprint);
        if (key == null) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Private key with fingerprint '%s' was not found", PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.MISSING_KEY);
        }
        return key;
    }

    public PGPPrivateKey decryptPrivateKey(Long fingerprint, Optional<String> passphrase) {
        PGPSecretKey encryptedKey = this.getPrivateKey(fingerprint);
        String passphraseText = passphrase.orElseGet(() -> this.passPhrasesMap.get(fingerprint));
        if (passphraseText == null) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)("Passphrase not available for key " + PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE);
        }
        try {
            return encryptedKey.extractPrivateKey(PgpEncrypter.PBE_SECRET_KEY_DECRYPTOR_BUILDER.build(passphraseText.toCharArray()));
        }
        catch (PGPException e) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)("Passphrase is not valid for key " + PgpEncrypter.formatKeyFingerprint(fingerprint)));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.PASSPHRASE, (Throwable)e);
        }
    }

    public PGPPrivateKey decryptPrivateKey(Long fingerprint) {
        return this.decryptPrivateKey(fingerprint, Optional.empty());
    }

    private void readPublicKeys(String path) {
        try (InputStream inputStream = IOUtils.getResourceAsStream((String)path, this.getClass());){
            Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, () -> String.format("Public PGP keyring '%s' does not exist", path));
            PGPPublicKeyRingCollection publicKeys = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream), (KeyFingerPrintCalculator)PgpEncrypter.KEY_FINGERPRINT_CALCULATOR);
            inputStream.close();
            publicKeys.getKeyRings().forEachRemaining(keyRing -> keyRing.getPublicKeys().forEachRemaining(key -> {
                this.publicKeyMap.put(key.getKeyID(), (PGPPublicKey)key);
                key.getUserIDs().forEachRemaining(principal -> {
                    if (this.principalMap.containsKey(principal) && key.getKeyID() != this.principalMap.get(principal).longValue()) {
                        throw new IllegalArgumentException(String.format("Principal '%s' appears more than once in different keys (%s and %s)", principal, key.getKeyID(), this.principalMap.get(principal)));
                    }
                    this.principalMap.put((String)principal, key.getKeyID());
                });
            }));
        }
        catch (IOException | PGPException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void readPrivateKeys(String path) {
        PGPSecretKeyRingCollection privateKeys = this.readPGPSecretKeyRingCollection(path);
        privateKeys.getKeyRings().forEachRemaining(keyRing -> keyRing.getSecretKeys().forEachRemaining(key -> {
            this.privateKeyMap.put(key.getKeyID(), (PGPSecretKey)key);
            key.getUserIDs().forEachRemaining(principal -> {
                if (this.principalMap.containsKey(principal) && key.getKeyID() != this.principalMap.get(principal).longValue()) {
                    throw new IllegalArgumentException(String.format("Principal '%s' appears more than once in different keys (%s and %s)", principal, key.getKeyID(), this.principalMap.get(principal)));
                }
                this.principalMap.put((String)principal, key.getKeyID());
            });
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PGPSecretKeyRingCollection readPGPSecretKeyRingCollection(String path) {
        try (InputStream inputStream = IOUtils.getResourceAsStream((String)path, this.getClass());){
            Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, () -> String.format("Private PGP keyring '%s' does not exist", path));
            PGPObjectFactory pgpFact = new PGPObjectFactory(PGPUtil.getDecoderStream(inputStream), (KeyFingerPrintCalculator)PgpEncrypter.KEY_FINGERPRINT_CALCULATOR);
            ArrayList<PGPSecretKeyRing> secretRings = new ArrayList<PGPSecretKeyRing>();
            for (Object obj : pgpFact) {
                if (!(obj instanceof PGPSecretKeyRing)) continue;
                secretRings.add((PGPSecretKeyRing)obj);
            }
            PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(secretRings);
            return pGPSecretKeyRingCollection;
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

