/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.api.checksum;

import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.commons.codec.digest.DigestUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public enum ChecksumAlgorithm {
    CRC32,
    MD2,
    MD5,
    SHA_1,
    SHA_256,
    SHA_512;


    public String digest(InputStream inputStream) {
        try {
            switch (this) {
                case CRC32: {
                    CRC32 sum = new CRC32();
                    sum.update(IOUtils.toByteArray((InputStream)inputStream));
                    return Long.toHexString(sum.getValue());
                }
                case MD2: {
                    return DigestUtils.md2Hex((InputStream)inputStream);
                }
                case MD5: {
                    return DigestUtils.md5Hex((InputStream)inputStream);
                }
                case SHA_1: {
                    return DigestUtils.sha1Hex((InputStream)inputStream);
                }
                case SHA_256: {
                    return DigestUtils.sha256Hex((InputStream)inputStream);
                }
                case SHA_512: {
                    return DigestUtils.sha512Hex((InputStream)inputStream);
                }
            }
        }
        catch (IOException e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Error calculating checksum"), (ErrorTypeDefinition)CryptoErrors.CHECKSUM, (Throwable)e);
        }
        throw new RuntimeException("invalid algorithm " + this.name());
    }
}

