/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.pkcs.bc;

import java.io.InputStream;
import org.bouncycastle.shaded.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.crypto.CipherParameters;
import org.bouncycastle.shaded.crypto.ExtendedDigest;
import org.bouncycastle.shaded.crypto.digests.SHA1Digest;
import org.bouncycastle.shaded.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.shaded.crypto.io.CipherInputStream;
import org.bouncycastle.shaded.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.shaded.operator.GenericKey;
import org.bouncycastle.shaded.operator.InputDecryptor;
import org.bouncycastle.shaded.operator.InputDecryptorProvider;
import org.bouncycastle.shaded.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(algorithmIdentifier, PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

