/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle.shaded.bcpg.S2K;
import org.bouncycastle.shaded.crypto.BlockCipher;
import org.bouncycastle.shaded.crypto.BufferedBlockCipher;
import org.bouncycastle.shaded.crypto.InvalidCipherTextException;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcUtil;
import org.bouncycastle.shaded.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        super(cArray, argon2Params);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
            BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(true, blockCipher, byArray, new byte[blockCipher.getBlockSize()]);
            byte[] byArray3 = new byte[byArray2.length];
            int n2 = bufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
            n2 += bufferedBlockCipher.doFinal(byArray3, n2);
            return byArray3;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("encryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

