/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp;

import java.io.InputStream;
import org.bouncycastle.shaded.bcpg.InputStreamPacket;
import org.bouncycastle.shaded.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.shaded.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.shaded.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.shaded.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPSessionKey;
import org.bouncycastle.shaded.openpgp.PGPSymmetricKeyEncryptedData;
import org.bouncycastle.shaded.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.shaded.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.shaded.util.Arrays;

public class PGPPBEEncryptedData
extends PGPSymmetricKeyEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = symmetricKeyEncSessionPacket;
        PGPPBEEncryptedData.enforceConstraints(symmetricKeyEncSessionPacket, inputStreamPacket);
    }

    private static void enforceConstraints(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        SymmetricEncIntegrityPacket symmetricEncIntegrityPacket;
        switch (symmetricKeyEncSessionPacket.getVersion()) {
            case 4: {
                if (inputStreamPacket instanceof SymmetricEncDataPacket) {
                    return;
                }
                if (inputStreamPacket instanceof SymmetricEncIntegrityPacket) {
                    SymmetricEncIntegrityPacket symmetricEncIntegrityPacket2 = (SymmetricEncIntegrityPacket)inputStreamPacket;
                    if (symmetricEncIntegrityPacket2.getVersion() == 1) {
                        return;
                    }
                    throw new IllegalArgumentException("Version 4 SKESK cannot precede SEIPD of version " + symmetricEncIntegrityPacket2.getVersion());
                }
            }
            case 5: {
                break;
            }
            case 6: {
                if (!(inputStreamPacket instanceof SymmetricEncIntegrityPacket)) {
                    throw new IllegalArgumentException("Version 6 SKESK MUST be followed only by SEIPD version 2");
                }
                symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)inputStreamPacket;
                if (symmetricEncIntegrityPacket.getVersion() == 2) break;
                throw new IllegalArgumentException("Version 6 SKESK MUST be followed only by SEIPD version 2");
            }
        }
        if (inputStreamPacket instanceof SymmetricEncDataPacket && symmetricKeyEncSessionPacket.getVersion() != 4) {
            throw new IllegalArgumentException("Version of SKESK packet preceding a SED packet can only be 4.");
        }
        if (inputStreamPacket instanceof SymmetricEncIntegrityPacket) {
            symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)inputStreamPacket;
            if (symmetricKeyEncSessionPacket.getVersion() == 4 && symmetricEncIntegrityPacket.getVersion() != 1) {
                throw new IllegalArgumentException("Version 4 SKESK can only precede version 1 SEIPD.");
            }
            if (symmetricKeyEncSessionPacket.getVersion() == 6 && symmetricEncIntegrityPacket.getVersion() == 1) {
                throw new IllegalArgumentException("Version 6 SKESK packet MUST NOT precede a V1 SEIPD packet.");
            }
        }
    }

    @Override
    public int getVersion() {
        return this.keyData.getVersion();
    }

    @Override
    public int getAlgorithm() {
        return this.keyData.getEncAlgorithm();
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 4) {
            byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
            byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
            return byArray2[0];
        }
        if (this.keyData.getVersion() == 5) {
            return this.keyData.getEncAlgorithm();
        }
        return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
    }

    public PGPSessionKey getSessionKey(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        int n = this.getVersion();
        if (n == 4) {
            byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
            int n2 = byArray2[0] & 0xFF;
            byte[] byArray3 = Arrays.copyOfRange(byArray2, 1, byArray2.length);
            return new PGPSessionKey(n2, byArray3);
        }
        if (n == 5 || n == 6) {
            int n3 = this.getSymmetricAlgorithm(pBEDataDecryptorFactory);
            byte[] byArray4 = pBEDataDecryptorFactory.recoverAEADEncryptedSessionData(this.keyData, byArray);
            return new PGPSessionKey(n3, byArray4);
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + n);
    }

    public InputStream getDataStream(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey pGPSessionKey = this.getSessionKey(pBEDataDecryptorFactory);
            this.encStream = this.createDecryptionStream(pBEDataDecryptorFactory, pGPSessionKey);
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey pGPSessionKey = sessionKeyDataDecryptorFactory.getSessionKey();
            this.encStream = this.createDecryptionStream(sessionKeyDataDecryptorFactory, pGPSessionKey);
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }
}

