/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms;

import org.bouncycastle.shaded.asn1.ASN1OctetString;
import org.bouncycastle.shaded.asn1.DEROctetString;
import org.bouncycastle.shaded.asn1.cms.KEKIdentifier;
import org.bouncycastle.shaded.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.shaded.asn1.cms.RecipientInfo;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.RecipientInfoGenerator;
import org.bouncycastle.shaded.operator.GenericKey;
import org.bouncycastle.shaded.operator.OperatorException;
import org.bouncycastle.shaded.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), (ASN1OctetString)dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

