/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.shaded.asn1.ASN1Encodable;
import org.bouncycastle.shaded.asn1.BEROctetString;
import org.bouncycastle.shaded.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.shaded.asn1.cms.CompressedData;
import org.bouncycastle.shaded.asn1.cms.ContentInfo;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cms.CMSCompressedData;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.CMSTypedData;
import org.bouncycastle.shaded.operator.OutputCompressor;

public class CMSCompressedDataGenerator {
    public static final String ZLIB = CMSObjectIdentifiers.zlibCompress.getId();

    public CMSCompressedData generate(CMSTypedData cMSTypedData, OutputCompressor outputCompressor) throws CMSException {
        BEROctetString bEROctetString;
        AlgorithmIdentifier algorithmIdentifier;
        OutputStream outputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = outputCompressor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write(outputStream);
            outputStream.close();
            algorithmIdentifier = outputCompressor.getAlgorithmIdentifier();
            bEROctetString = new BEROctetString(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new CMSException("exception encoding data.", iOException);
        }
        byteArrayOutputStream = new ContentInfo(cMSTypedData.getContentType(), (ASN1Encodable)bEROctetString);
        outputStream = new ContentInfo(CMSObjectIdentifiers.compressedData, (ASN1Encodable)new CompressedData(algorithmIdentifier, (ContentInfo)byteArrayOutputStream));
        return new CMSCompressedData((ContentInfo)outputStream);
    }
}

