/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.crmf;

import java.io.IOException;
import org.bouncycastle.shaded.asn1.cms.EnvelopedData;
import org.bouncycastle.shaded.asn1.crmf.CRMFObjectIdentifiers;
import org.bouncycastle.shaded.asn1.crmf.EncKeyWithID;
import org.bouncycastle.shaded.asn1.crmf.EncryptedKey;
import org.bouncycastle.shaded.asn1.crmf.PKIArchiveOptions;
import org.bouncycastle.shaded.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.shaded.asn1.x509.GeneralName;
import org.bouncycastle.shaded.cert.crmf.PKIArchiveControl;
import org.bouncycastle.shaded.cms.CMSEnvelopedData;
import org.bouncycastle.shaded.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.CMSProcessableByteArray;
import org.bouncycastle.shaded.cms.RecipientInfoGenerator;
import org.bouncycastle.shaded.operator.OutputEncryptor;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientInfoGenerator) {
        this.envGen.addRecipientInfoGenerator(recipientInfoGenerator);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor outputEncryptor) throws CMSException {
        CMSEnvelopedData cMSEnvelopedData = this.envGen.generate(this.keyContent, outputEncryptor);
        EnvelopedData envelopedData = EnvelopedData.getInstance((Object)cMSEnvelopedData.toASN1Structure().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envelopedData)));
    }
}

