/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.crmf;

import org.bouncycastle.shaded.asn1.ASN1Encodable;
import org.bouncycastle.shaded.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.shaded.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.shaded.asn1.cms.ContentInfo;
import org.bouncycastle.shaded.asn1.cms.EnvelopedData;
import org.bouncycastle.shaded.asn1.crmf.CRMFObjectIdentifiers;
import org.bouncycastle.shaded.asn1.crmf.EncryptedKey;
import org.bouncycastle.shaded.asn1.crmf.PKIArchiveOptions;
import org.bouncycastle.shaded.cert.crmf.CRMFException;
import org.bouncycastle.shaded.cert.crmf.Control;
import org.bouncycastle.shaded.cms.CMSEnvelopedData;
import org.bouncycastle.shaded.cms.CMSException;

public class PKIArchiveControl
implements Control {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private static final ASN1ObjectIdentifier type = CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions;
    private final PKIArchiveOptions pkiArchiveOptions;

    public PKIArchiveControl(PKIArchiveOptions pKIArchiveOptions) {
        this.pkiArchiveOptions = pKIArchiveOptions;
    }

    @Override
    public ASN1ObjectIdentifier getType() {
        return type;
    }

    @Override
    public ASN1Encodable getValue() {
        return this.pkiArchiveOptions;
    }

    public int getArchiveType() {
        return this.pkiArchiveOptions.getType();
    }

    public boolean isEnvelopedData() {
        EncryptedKey encryptedKey = EncryptedKey.getInstance((Object)this.pkiArchiveOptions.getValue());
        return !encryptedKey.isEncryptedValue();
    }

    public CMSEnvelopedData getEnvelopedData() throws CRMFException {
        try {
            EncryptedKey encryptedKey = EncryptedKey.getInstance((Object)this.pkiArchiveOptions.getValue());
            EnvelopedData envelopedData = EnvelopedData.getInstance((Object)encryptedKey.getValue());
            return new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, (ASN1Encodable)envelopedData));
        }
        catch (CMSException cMSException) {
            throw new CRMFException("CMS parsing error: " + cMSException.getMessage(), cMSException.getCause());
        }
        catch (Exception exception) {
            throw new CRMFException("CRMF parsing error: " + exception.getMessage(), exception);
        }
    }
}

