/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.cmp;

import java.math.BigInteger;
import org.bouncycastle.shaded.asn1.ASN1Object;
import org.bouncycastle.shaded.asn1.cmp.CMPCertificate;
import org.bouncycastle.shaded.asn1.cmp.CertStatus;
import org.bouncycastle.shaded.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.cmp.CMPException;
import org.bouncycastle.shaded.cert.cmp.CMPUtil;
import org.bouncycastle.shaded.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.shaded.operator.DigestCalculator;
import org.bouncycastle.shaded.operator.DigestCalculatorProvider;
import org.bouncycastle.shaded.operator.OperatorCreationException;
import org.bouncycastle.shaded.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), digestCalculatorProvider);
    }

    public boolean isVerified(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        DigestCalculator digestCalculator;
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgFinder.find(algorithmIdentifier);
        if (algorithmIdentifier2 == null) {
            throw new CMPException("cannot find algorithm for digest from signature");
        }
        try {
            digestCalculator = digestCalculatorProvider.get(algorithmIdentifier2);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMPException("unable to create digester: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        CMPUtil.derEncodeToStream((ASN1Object)cMPCertificate, digestCalculator.getOutputStream());
        return Arrays.areEqual(this.certStatus.getCertHash().getOctets(), digestCalculator.getDigest());
    }
}

