/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.pgp;

import com.mulesoft.modules.cryptography.api.pgp.config.PgpKeyInfo;
import com.mulesoft.modules.cryptography.api.pgp.config.PgpSignatureAlgorithm;
import com.mulesoft.modules.cryptography.internal.FipsUtils;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.pgp.config.PgpConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bouncycastle.shaded.bcpg.BCPGOutputStream;
import org.bouncycastle.shaded.openpgp.PGPCompressedData;
import org.bouncycastle.shaded.openpgp.PGPObjectFactory;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPSignature;
import org.bouncycastle.shaded.openpgp.PGPSignatureGenerator;
import org.bouncycastle.shaded.openpgp.PGPSignatureList;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class PgpSigner {
    private PgpConfiguration config;

    public PgpSigner(PgpConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream sign(InputStream inputStream, PgpKeyInfo keyInfo, PgpSignatureAlgorithm algorithm) {
        try {
            if (keyInfo.isSymmetric()) {
                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signing is only possible with asymmetric keys"), (ErrorTypeDefinition)CryptoErrors.KEY);
            }
            PGPPrivateKey pgpPrivateKey = keyInfo.getPrivateKey(this.config.getKeystore());
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                int keyAlgorithm = pgpPrivateKey.getPublicKeyPacket().getAlgorithm();
                JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(keyAlgorithm, algorithm.getNumericId());
                if (!FipsUtils.isFipsEnabled()) {
                    contentSignerBuilder.setProvider("BC");
                }
                PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(contentSignerBuilder);
                signatureGenerator.init(0, pgpPrivateKey);
                byte[] inputBytes = org.mule.runtime.core.api.util.IOUtils.toByteArray((InputStream)inputStream);
                signatureGenerator.update(inputBytes);
                BCPGOutputStream bcpgOutputStream = new BCPGOutputStream((OutputStream)result);
                try {
                    signatureGenerator.generate().encode(bcpgOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)bcpgOutputStream);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result.toByteArray());
                return byteArrayInputStream;
            }
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Could not sign with PGP"), (ErrorTypeDefinition)CryptoErrors.SIGNATURE, (Throwable)e);
        }
    }

    public boolean validate(InputStream inputStream, InputStream expectedSignature) {
        try {
            PGPSignatureList pgpSigList;
            InputStream sigInputStream = PGPUtil.getDecoderStream(expectedSignature);
            PGPObjectFactory pgpObjFactory = new JcaPGPObjectFactory(sigInputStream);
            Object obj = pgpObjFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                PGPCompressedData c1 = (PGPCompressedData)obj;
                pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), null);
                pgpSigList = (PGPSignatureList)pgpObjFactory.nextObject();
            } else {
                pgpSigList = (PGPSignatureList)obj;
            }
            PGPSignature sig = pgpSigList.get(0);
            PGPPublicKey pubKey = this.config.getKeystore().getPublicKey(sig.getKeyID());
            JcaPGPContentVerifierBuilderProvider verifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider();
            if (!FipsUtils.isFipsEnabled()) {
                verifierBuilderProvider.setProvider("BC");
            }
            sig.init(verifierBuilderProvider, pubKey);
            byte[] inputBytes = org.mule.runtime.core.api.util.IOUtils.toByteArray((InputStream)inputStream);
            sig.update(inputBytes);
            sigInputStream.close();
            return sig.verify();
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"PGP signature verification failed"), (ErrorTypeDefinition)CryptoErrors.VALIDATION, (Throwable)e);
        }
    }
}

