/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal;

import java.security.Provider;
import java.util.function.Supplier;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import sun.security.jca.ProviderList;
import sun.security.jca.Providers;

public class FipsUtils {
    public static boolean isFipsEnabled() {
        return "fips140-2".equals(System.getProperty("mule.security.model"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithinSecurityProvider(Supplier<T> supplier) {
        if (FipsUtils.isFipsEnabled()) {
            return supplier.get();
        }
        ProviderList providerList = FipsUtils.getNonFipsProviderList();
        ProviderList previousProviders = Providers.beginThreadProviderList(providerList);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            Providers.endThreadProviderList(previousProviders);
        }
    }

    private static ProviderList getNonFipsProviderList() {
        return ProviderList.add(Providers.getFullProviderList(), FipsUtils.getBouncyCastleProvider());
    }

    private static Provider getBouncyCastleProvider() {
        return BouncyCastleProviderInstanceHolder.INSTANCE;
    }

    private static class BouncyCastleProviderInstanceHolder {
        private static final Provider INSTANCE = new BouncyCastleProvider();

        private BouncyCastleProviderInstanceHolder() {
        }
    }
}

