/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.jcajce;

import java.security.Provider;
import org.bouncycastle.shaded.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.shaded.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPSessionKey;
import org.bouncycastle.shaded.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.shaded.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.shaded.openpgp.operator.jcajce.OperatorHelper;

public class JceSessionKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public SessionKeyDataDecryptorFactory build(PGPSessionKey pGPSessionKey) {
        return new JceSessionKeyDataDecryptorFactory(this.helper, pGPSessionKey);
    }

    private static class JceSessionKeyDataDecryptorFactory
    implements SessionKeyDataDecryptorFactory {
        private final OperatorHelper helper;
        private final PGPSessionKey sessionKey;

        public JceSessionKeyDataDecryptorFactory(OperatorHelper operatorHelper, PGPSessionKey pGPSessionKey) {
            this.helper = operatorHelper;
            this.sessionKey = pGPSessionKey;
        }

        public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
            throw new IllegalStateException("trying to recover session data from session key!");
        }

        public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
            throw new IllegalStateException("trying to recover session data from session key!");
        }

        public PGPSessionKey getSessionKey() {
            return this.sessionKey;
        }

        public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
            return this.helper.createDataDecryptor(bl, n, byArray);
        }
    }
}

