/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.openpgp.operator.bc;

import java.io.OutputStream;
import org.bouncycastle.shaded.crypto.Signer;
import org.bouncycastle.shaded.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.shaded.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.shaded.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.shaded.openpgp.operator.bc.SignerOutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new BcPGPContentVerifierBuilder(n, n2);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            AsymmetricKeyParameter asymmetricKeyParameter = BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey);
            final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, asymmetricKeyParameter);
            signer.init(false, asymmetricKeyParameter);
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    return signer.verifySignature(byArray);
                }

                public OutputStream getOutputStream() {
                    return new SignerOutputStream(signer);
                }
            };
        }
    }
}

