/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.jcajce.provider.symmetric;

import org.bouncycastle.shaded.crypto.CipherKeyGenerator;
import org.bouncycastle.shaded.crypto.engines.SkipjackEngine;
import org.bouncycastle.shaded.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.shaded.crypto.macs.CFBBlockCipherMac;
import org.bouncycastle.shaded.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle.shaded.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastle.shaded.jcajce.provider.util.AlgorithmProvider;

public final class Skipjack {
    private Skipjack() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Skipjack IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new SkipjackEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Skipjack", 80, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new CBCBlockCipherMac(new SkipjackEngine()));
        }
    }

    public static class MacCFB8
    extends BaseMac {
        public MacCFB8() {
            super(new CFBBlockCipherMac(new SkipjackEngine()));
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Skipjack.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.SKIPJACK", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.SKIPJACK", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.SKIPJACK", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Mac.SKIPJACKMAC", PREFIX + "$Mac");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.SKIPJACK", "SKIPJACKMAC");
            configurableProvider.addAlgorithm("Mac.SKIPJACKMAC/CFB8", PREFIX + "$MacCFB8");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.SKIPJACK/CFB8", "SKIPJACKMAC/CFB8");
        }
    }
}

