/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms.jcajce;

import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;
import org.bouncycastle.shaded.asn1.ASN1OctetString;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.RecipientOperator;
import org.bouncycastle.shaded.cms.jcajce.JceKeyAgreeRecipient;
import org.bouncycastle.shaded.jcajce.io.MacOutputStream;
import org.bouncycastle.shaded.operator.GenericKey;
import org.bouncycastle.shaded.operator.MacCalculator;
import org.bouncycastle.shaded.operator.jcajce.JceGenericKey;

public class JceKeyAgreeAuthenticatedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeAuthenticatedRecipient(PrivateKey privateKey) {
        super(privateKey);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, subjectPublicKeyInfo, aSN1OctetString, byArray);
        final Mac mac = this.contentHelper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

