/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cms;

import java.io.IOException;
import org.bouncycastle.shaded.asn1.cms.KEKIdentifier;
import org.bouncycastle.shaded.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.shaded.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.shaded.cms.AuthAttributesProvider;
import org.bouncycastle.shaded.cms.CMSException;
import org.bouncycastle.shaded.cms.CMSSecureReadable;
import org.bouncycastle.shaded.cms.KEKRecipient;
import org.bouncycastle.shaded.cms.KEKRecipientId;
import org.bouncycastle.shaded.cms.Recipient;
import org.bouncycastle.shaded.cms.RecipientInformation;
import org.bouncycastle.shaded.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

