/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.shaded.cert.dane;

import org.bouncycastle.shaded.cert.X509CertificateHolder;
import org.bouncycastle.shaded.cert.dane.DANEEntry;
import org.bouncycastle.shaded.cert.dane.DANEEntrySelector;
import org.bouncycastle.shaded.cert.dane.DANEEntrySelectorFactory;
import org.bouncycastle.shaded.cert.dane.DANEException;
import org.bouncycastle.shaded.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String string, X509CertificateHolder x509CertificateHolder) throws DANEException {
        return this.createEntry(string, 3, x509CertificateHolder);
    }

    public DANEEntry createEntry(String string, int n, X509CertificateHolder x509CertificateHolder) throws DANEException {
        if (n < 0 || n > 3) {
            throw new DANEException("unknown certificate usage: " + n);
        }
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        byte[] byArray = new byte[]{(byte)n, 0, 0};
        return new DANEEntry(dANEEntrySelector.getDomainName(), byArray, x509CertificateHolder);
    }
}

