/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.reference;

import com.mulesoft.modules.cryptography.api.xml.config.XmlSignDigestAlgorithm;
import com.mulesoft.modules.cryptography.api.xml.config.XmlSignatureType;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.xml.reference.DetachedSignatureContextProvider;
import com.mulesoft.modules.cryptography.internal.xml.reference.EnvelopedSignatureContextProvider;
import com.mulesoft.modules.cryptography.internal.xml.reference.EnvelopingSignatureContextProvider;
import java.util.List;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public interface SignatureContextProvider {
    public Reference getReference();

    public List<XMLObject> getReferencedObjects();

    public Node getSignatureParentNode();

    default public Document preProcess(Document document) {
        return document;
    }

    default public Document postProcess(Document document) {
        return document;
    }

    public static SignatureContextProvider createContextFor(XmlSignatureType type, XmlSignDigestAlgorithm digestAlgorithm, Document document, String elementPath) {
        switch (type) {
            case DETACHED: {
                return new DetachedSignatureContextProvider(digestAlgorithm, document, elementPath);
            }
            case ENVELOPED: {
                return EnvelopedSignatureContextProvider.contextProviderForElementPath(digestAlgorithm, document, elementPath);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureContextProvider(digestAlgorithm, document);
            }
        }
        throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Invalid signature type"), (ErrorTypeDefinition)CryptoErrors.PARAMETERS);
    }
}

