/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.xml.impl;

import com.mulesoft.modules.cryptography.internal.xml.impl.AlgorithmEqualityChecker;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public class X509KeySelector
extends KeySelector {
    private KeyStore keyStore;
    private boolean useFirstCertificateFound;

    public X509KeySelector(KeyStore keystore, boolean useFirstCertificateFound) {
        this.keyStore = keystore;
        this.useFirstCertificateFound = useFirstCertificateFound;
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        SignatureMethod sm = (SignatureMethod)method;
        try {
            if (keyInfo == null || this.keyStore.size() == 0) {
                return new SimpleKeySelectorResult(null);
            }
            for (XMLStructure kiType : keyInfo.getContent()) {
                X509Data xd;
                SimpleKeySelectorResult ksr;
                if (!(kiType instanceof X509Data) || (ksr = this.x509DataSelect(xd = (X509Data)kiType, sm)) == null) continue;
                return ksr;
            }
        }
        catch (KeyStoreException kse) {
            throw new KeySelectorException(kse);
        }
        return new SimpleKeySelectorResult(null);
    }

    private SimpleKeySelectorResult selectFromKeystore(CertSelector cs) throws KeyStoreException {
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = this.keyStore.getCertificate(alias);
            if (cert == null || !cs.match(cert)) continue;
            return new SimpleKeySelectorResult(cert.getPublicKey());
        }
        return null;
    }

    private SimpleKeySelectorResult selectFromCertificate(X509Certificate xcert, SignatureMethod sm) throws KeyStoreException {
        PublicKey pk;
        boolean[] keyUsage = xcert.getKeyUsage();
        if (keyUsage != null && !keyUsage[0]) {
            return null;
        }
        String alias = this.keyStore.getCertificateAlias(xcert);
        if (alias != null) {
            PublicKey pk2 = this.keyStore.getCertificate(alias).getPublicKey();
            if (this.keyAlgorithmMatches(sm, pk2)) {
                return new SimpleKeySelectorResult(pk2);
            }
        } else if (this.useFirstCertificateFound && this.keyAlgorithmMatches(sm, pk = xcert.getPublicKey())) {
            return new SimpleKeySelectorResult(pk);
        }
        return null;
    }

    private boolean keyAlgorithmMatches(SignatureMethod sm, PublicKey pk) {
        return AlgorithmEqualityChecker.algEquals(sm.getAlgorithm(), pk.getAlgorithm());
    }

    private String getPKAlgorithmOID(String algURI) {
        if (algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return "1.2.840.10040.4.1";
        }
        if (algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return "1.2.840.113549.1.1";
        }
        return null;
    }

    private SimpleKeySelectorResult x509DataSelect(X509Data xd, SignatureMethod sm) throws KeyStoreException, KeySelectorException {
        String algOID = this.getPKAlgorithmOID(sm.getAlgorithm());
        for (Object o : xd.getContent()) {
            X509CertSelector xcs;
            SimpleKeySelectorResult ksr;
            if (o instanceof X509Certificate) {
                ksr = this.selectFromCertificate((X509Certificate)o, sm);
            } else if (o instanceof X509IssuerSerial) {
                xcs = this.selectFromIssuerSerial(algOID, (X509IssuerSerial)o);
                ksr = this.selectFromKeystore(xcs);
            } else if (o instanceof String) {
                xcs = this.selectFromString(algOID, (String)o);
                ksr = this.selectFromKeystore(xcs);
            } else {
                if (!(o instanceof byte[])) continue;
                xcs = this.selectFromByteArray(algOID, (byte[])o);
                ksr = this.selectFromKeystore(xcs);
            }
            if (ksr == null) continue;
            return ksr;
        }
        return null;
    }

    private X509CertSelector selectFromByteArray(String algOID, byte[] o) throws KeySelectorException {
        byte[] ski = o;
        X509CertSelector xcs = new X509CertSelector();
        try {
            xcs.setSubjectPublicKeyAlgID(algOID);
        }
        catch (IOException ioe) {
            throw new KeySelectorException(ioe);
        }
        byte[] encodedSki = new byte[ski.length + 2];
        encodedSki[0] = 4;
        encodedSki[1] = (byte)ski.length;
        System.arraycopy(ski, 0, encodedSki, 2, ski.length);
        xcs.setSubjectKeyIdentifier(encodedSki);
        return xcs;
    }

    private X509CertSelector selectFromString(String algOID, String o) throws KeySelectorException {
        String sn = o;
        X509CertSelector xcs = new X509CertSelector();
        try {
            xcs.setSubjectPublicKeyAlgID(algOID);
            xcs.setSubject(new X500Principal(sn).getName());
        }
        catch (IOException ioe) {
            throw new KeySelectorException(ioe);
        }
        return xcs;
    }

    private X509CertSelector selectFromIssuerSerial(String algOID, X509IssuerSerial o) throws KeySelectorException {
        X509IssuerSerial xis = o;
        X509CertSelector xcs = new X509CertSelector();
        try {
            xcs.setSubjectPublicKeyAlgID(algOID);
            xcs.setSerialNumber(xis.getSerialNumber());
            xcs.setIssuer(new X500Principal(xis.getIssuerName()).getName());
        }
        catch (IOException ioe) {
            throw new KeySelectorException(ioe);
        }
        return xcs;
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final Key key;

        SimpleKeySelectorResult(Key key) {
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

