/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.cryptography.internal.checksum;

import com.mulesoft.modules.cryptography.api.checksum.ChecksumAlgorithm;
import com.mulesoft.modules.cryptography.internal.errors.ChecksumErrorTypeProvider;
import com.mulesoft.modules.cryptography.internal.errors.CryptoErrors;
import com.mulesoft.modules.cryptography.internal.errors.ValidationErrorTypeProvider;
import java.io.InputStream;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class ChecksumOperations {
    @MediaType(value="text/plain")
    @Throws(value={ChecksumErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public String calculateChecksum(@Optional(defaultValue="SHA_256") ChecksumAlgorithm algorithm, @Content @Optional(defaultValue="#[payload]") InputStream content) {
        return algorithm.digest(content);
    }

    @Validator
    @Throws(value={ValidationErrorTypeProvider.class})
    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void validateChecksum(@Optional(defaultValue="SHA_256") ChecksumAlgorithm algorithm, @Optional(defaultValue="#[payload]") InputStream value, String expected) {
        String actual = algorithm.digest(value);
        if (!actual.equals(expected)) {
            I18nMessage message = I18nMessageFactory.createStaticMessage((String)String.format("Checksum does not match (%s), expected '%s' but was '%s'", algorithm.name(), expected, actual));
            throw new ModuleException(message, (ErrorTypeDefinition)CryptoErrors.VALIDATION);
        }
    }
}

