/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.key;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public class LocalObjectStore
implements ObjectStore {
    private Serializable value;
    private final String key;
    private final ObjectStore realObjectStore;

    public LocalObjectStore(ObjectStore realObjectStore, Serializable objectStoreValueFor, String key) {
        this.value = objectStoreValueFor;
        this.key = key;
        this.realObjectStore = realObjectStore;
    }

    public boolean contains(String key) throws ObjectStoreException {
        return this.checkKey(key) ? this.value != null : this.realObjectStore.contains(key);
    }

    private boolean checkKey(String key) {
        return this.key.equals(key);
    }

    public void store(String key, Serializable value) throws ObjectStoreException {
        if (this.checkKey(key)) {
            this.value = value;
        } else {
            this.realObjectStore.store(key, value);
        }
    }

    public Serializable retrieve(String key) throws ObjectStoreException {
        return this.checkKey(key) ? this.value : this.realObjectStore.retrieve(key);
    }

    public Serializable remove(String key) throws ObjectStoreException {
        if (this.checkKey(key)) {
            Serializable toRet = this.value;
            this.value = null;
            return toRet;
        }
        return this.realObjectStore.remove(key);
    }

    public boolean isPersistent() {
        throw new RuntimeException("Not implemented");
    }

    public void clear() throws ObjectStoreException {
        throw new RuntimeException("Not implemented");
    }

    public void open() throws ObjectStoreException {
        throw new RuntimeException("Not implemented");
    }

    public void close() throws ObjectStoreException {
        throw new RuntimeException("Not implemented");
    }

    public List<String> allKeys() throws ObjectStoreException {
        throw new RuntimeException("Not implemented");
    }

    public Map retrieveAll() throws ObjectStoreException {
        throw new RuntimeException("Not implemented");
    }

    public Serializable getValue() {
        return this.value;
    }
}

