/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.operation;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.awslambda.internal.config.AwsLambdaConfiguration;
import java.io.InputStream;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public abstract class CustomBaseRestOperation {
    @Inject
    private ExpressionLanguage expressionLanguage;

    protected void doRequest(AwsLambdaConfiguration config, RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            connection.request(builder, responseTimeoutMillis, this.resolveDefaultResponseMediaType(config), streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Exception t) {
            callback.error((Throwable)t);
        }
    }

    protected MediaType resolveDefaultResponseMediaType(AwsLambdaConfiguration config) {
        MediaType mediaType = this.getDefaultResponseMediaType();
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    private <T> BiConsumer<Result<T, HttpResponseAttributes>, Throwable> handleResponse(CompletionCallback<T, HttpResponseAttributes> callback) {
        return (r, e) -> {
            if (e != null) {
                callback.error(e);
            } else {
                callback.success(r);
            }
        };
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

