/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.UUID;
import org.json.JSONObject;

public class AssumeRoleResponse {
    @JsonProperty(value="AssumeRoleResult")
    private AssumeRoleResult result;
    @JsonProperty(value="ResponseMetadata")
    private ResponseMetadata metadata;

    public AssumeRoleResponse(JSONObject source) {
        this.result = new AssumeRoleResult(source.getJSONObject("AssumeRoleResult"));
        this.metadata = new ResponseMetadata(source.getJSONObject("ResponseMetadata"));
    }

    public AssumeRoleResult getResult() {
        return this.result;
    }

    public ResponseMetadata getMetadata() {
        return this.metadata;
    }

    public class ResponseMetadata {
        @JsonProperty(value="RequestId")
        private UUID requestId;

        public ResponseMetadata(JSONObject source) {
            this.requestId = UUID.fromString(source.getString("RequestId"));
        }

        public UUID getRequestId() {
            return this.requestId;
        }
    }

    public class AssumeRoleResult {
        @JsonProperty(value="AssumedRoleUser")
        private AssumedRoleUser user;
        @JsonProperty(value="Credentials")
        private Credentials credentials;

        public AssumeRoleResult(JSONObject source) {
            this.user = new AssumedRoleUser(source.getJSONObject("AssumedRoleUser"));
            this.credentials = new Credentials(source.getJSONObject("Credentials"));
        }

        public AssumedRoleUser getUser() {
            return this.user;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public class Credentials {
            @JsonProperty(value="AccessKeyId")
            private String accessKeyId;
            @JsonProperty(value="Expiration")
            private LocalDateTime expiration;
            @JsonProperty(value="SecretAccessKey")
            private String secretAccessKey;
            @JsonProperty(value="SessionToken")
            private String sessionToken;

            public Credentials(JSONObject source) {
                this.accessKeyId = source.getString("AccessKeyId");
                this.expiration = LocalDateTime.ofInstant(Instant.ofEpochSecond(source.getLong("Expiration")), ZoneId.systemDefault());
                this.secretAccessKey = source.getString("SecretAccessKey");
                this.sessionToken = source.getString("SessionToken");
            }

            public String getAccessKeyId() {
                return this.accessKeyId;
            }

            public LocalDateTime getExpiration() {
                return this.expiration;
            }

            public String getSecretAccessKey() {
                return this.secretAccessKey;
            }

            public String getSessionToken() {
                return this.sessionToken;
            }
        }

        public class AssumedRoleUser {
            @JsonProperty(value="Arn")
            private String arn;
            @JsonProperty(value="AssumedRoleId")
            private String assumedRoleId;

            public AssumedRoleUser(JSONObject source) {
                this.arn = source.getString("Arn");
                this.assumedRoleId = source.getString("AssumedRoleId");
            }

            public String getArn() {
                return this.arn;
            }

            public String getAssumedRoleId() {
                return this.assumedRoleId;
            }
        }
    }
}

