/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.model.dataexpressions.HttpRequestDataExpressionBinding;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestRequestBuilder;
import java.util.HashMap;
import java.util.Optional;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.HttpConstants;

public class HttpRequestDataExpression
implements DataExpression {
    private final String path;
    private final String method;
    private final HttpRequestDataExpressionBinding bindings;

    public HttpRequestDataExpression(String path, String method, HttpRequestDataExpressionBinding bindings) {
        this.path = path;
        this.method = method;
        this.bindings = bindings;
    }

    @Override
    public Object evaluate(EvaluationContext evaluationContext) {
        RestConfiguration configuration = (RestConfiguration)evaluationContext.resolveProperty("PROPERTY_CONFIGURATION");
        RestConnection connection = (RestConnection)evaluationContext.resolveProperty("PROPERTY_CONNECTION");
        RestRequestBuilder restRequestBuilder = this.getRestRequestBuilder(evaluationContext);
        return RequestStreamingUtils.doRequestAndConsumeString(connection, configuration, restRequestBuilder, this.getDefaultResponseMediaType());
    }

    private MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    private String getPathTemplate() {
        return this.path;
    }

    private Optional<HttpRequestDataExpressionBinding> getBindings() {
        return Optional.ofNullable(this.bindings);
    }

    private RestRequestBuilder getRestRequestBuilder(EvaluationContext evaluationContext) {
        String path = this.buildRequestPath(evaluationContext);
        RestConfiguration configuration = (RestConfiguration)evaluationContext.resolveProperty("PROPERTY_CONFIGURATION");
        RestConnection connection = (RestConnection)evaluationContext.resolveProperty("PROPERTY_CONNECTION");
        RestRequestBuilder restRequestBuilder = new RestRequestBuilder(connection.getBaseUri(), path, HttpConstants.Method.valueOf((String)this.method.toUpperCase()));
        this.getBindings().ifPresent(httpRequestDataExpressionBinding -> {
            httpRequestDataExpressionBinding.getHeaders().forEach(header -> restRequestBuilder.addHeader(header.getName(), this.getParameterValue(header.getValue(), evaluationContext)));
            httpRequestDataExpressionBinding.getQueryParameters().forEach(queryParameter -> restRequestBuilder.addQueryParam(queryParameter.getName(), this.getParameterValue(queryParameter.getValue(), evaluationContext)));
        });
        return restRequestBuilder;
    }

    private String buildRequestPath(EvaluationContext evaluationContext) {
        if (this.bindings.getUriParameters().isEmpty()) {
            return this.getPathTemplate();
        }
        HashMap uriParamValues = new HashMap();
        this.getBindings().ifPresent(httpRequestDataExpressionBinding -> httpRequestDataExpressionBinding.getUriParameters().forEach(uriParameter -> uriParamValues.put(uriParameter.getName(), this.getParameterValue(uriParameter.getValue(), evaluationContext))));
        String path = this.getPathTemplate();
        for (String key : uriParamValues.keySet()) {
            path = path.replace("{" + key + "}", (CharSequence)uriParamValues.get(key));
        }
        return path;
    }

    private String getParameterValue(Expression expression, EvaluationContext evaluationContext) {
        Object result = expression.evaluate(evaluationContext);
        if (result instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)result;
            result = typedValue.getValue();
        }
        if (result instanceof String) {
            return (String)result;
        }
        if (result instanceof Integer) {
            return String.valueOf(result);
        }
        if (result instanceof Double) {
            Double doubleResult = (Double)result;
            return doubleResult % 1.0 == 0.0 ? String.valueOf(doubleResult.intValue()) : String.valueOf(doubleResult);
        }
        throw new IllegalArgumentException(String.format("Expression '%s' did not return a String but `%s`", expression, result.getClass().getSimpleName()));
    }
}

