/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.api.version;

import com.mulesoft.anypoint.discovery.api.exception.InvalidHotFixVersionException;

/**
 * Describes the version of an artifact.
 */
public interface ArtifactVersion {

  /**
   * @return Major version.
   */
  int major();

  /**
   * @return Minor version.
   */
  int minor();

  /**
   * @return Patch level version.
   */
  int patch();

  /**
   * @return the {@link ArtifactVersion} in a {@link String} format.
   */
  String value();

  /**
   * @return the {@link ArtifactVersion} 'hot fix' number, i.e.: 0.0.1-hf33 is 33 and 0.0.1-hf66-SNAPSHOT is 66.
   * @throws InvalidHotFixVersionException if this {@link ArtifactVersion} is not a valid 'hot fix' version (i.e.:
   *                                       1.0.0-HFt800 is not a valid version).
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   */
  @Deprecated
  int hotFixNumber();

  /**
   * Compares whether another {@link ArtifactVersion} is older than this.
   *
   * @param anotherVersion to compare age.
   * @return true/false.
   */
  boolean olderThan(ArtifactVersion anotherVersion);

  /**
   * @return whether this {@link ArtifactVersion} is a snapshot or not.
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   */
  @Deprecated
  boolean isSnapshot();

  /**
   * @return whether this {@link ArtifactVersion} is a 'hot fix' version or not (i.e.: 0.0.1-HF666, 0.0.1-hf32 and
   * 0.0.1-hf999-SNAPSHOT are hot fixes of version 0.0.1).
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   */
  @Deprecated
  boolean isHotFix();

  /**
   * @return whether this {@link ArtifactVersion} is a 'hot fix' version of another one (i.e.: 0.0.1-HF3 is a hot fix of
   * version 0.0.1 but 0.0.1-myVersion is not).
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   */
  @Deprecated
  boolean isHotFixOf(ArtifactVersion anotherVersion);

  /**
   * @return whether this {@link ArtifactVersion} is an 'early access' version or not. An early access version MUST
   * contain the suffix 'eaX' where X is a positive integer (i.e.: 0.0.1-ea1 and 0.0.1-ea2-SNAPSHOT are early access
   * versions).
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   */
  @Deprecated
  boolean isEarlyAccess();

  /**
   * @return whether this {@link ArtifactVersion} is a 'release candidate' version or not. A release candidate version
   * MUST contain the suffit 'rcX' where X is a positive integer. (i.e.: 0.0.1-rc1 and 0.0.1-rc2-SNAPSHOT are early
   * access versions).
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   */
  @Deprecated
  boolean isReleaseCandidate();

  /**
   * @return whether this {@link ArtifactVersion} is a dated released version. Dated versions are in the form of
   * major.minor.patch-YYYYMMDD. These versions are specific for CloudHub (CH) and Runtime Fabric (RTF).
   * @since 3.0.0.
   * @deprecated {@link ArtifactVersion} have now a proper hierarchy and you can use it to visit specific
   * implementations.
   * <p>
   * NOTE: This format is not server compliant.
   */
  @Deprecated
  boolean isChPatch();

  /**
   * @return releases a new version of this instance, one that it is not a SNAPSHOT.
   */
  ArtifactVersion release();

  <T> T accept(VersionVisitor<T> visitor);
}
