/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.cache;

import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Queue;

public class AnalyticsEventCache
implements Queue<AnalyticsHttpEvent> {
    private final SizeLimitedQueue<AnalyticsHttpEvent> queue;
    private final String queueName;

    public AnalyticsEventCache(SizeLimitedQueue<AnalyticsHttpEvent> queue, String queueName) {
        this.queue = queue;
        this.queueName = queueName;
    }

    public String getName() {
        return this.queueName;
    }

    private synchronized boolean doAdd(AnalyticsHttpEvent event) {
        return this.queue.add((Object)event);
    }

    private Optional<AnalyticsHttpEvent> doRetrieve() {
        return this.queue.retrieve();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public synchronized boolean add(AnalyticsHttpEvent event) {
        boolean added = this.doAdd(event);
        if (!added) {
            throw new IllegalArgumentException("Element could not be added to the queue");
        }
        return true;
    }

    @Override
    public boolean offer(AnalyticsHttpEvent httpEvent) {
        return this.doAdd(httpEvent);
    }

    @Override
    public AnalyticsHttpEvent remove() {
        return this.doRetrieve().get();
    }

    @Override
    public AnalyticsHttpEvent poll() {
        return this.doRetrieve().orElse(null);
    }

    @Override
    public AnalyticsHttpEvent element() {
        return (AnalyticsHttpEvent)this.queue.peek().get();
    }

    @Override
    public AnalyticsHttpEvent peek() {
        return this.queue.peek().orElse(null);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends AnalyticsHttpEvent> events) {
        boolean anyAdded = false;
        for (AnalyticsHttpEvent analyticsHttpEvent : events) {
            anyAdded = this.doAdd(analyticsHttpEvent) || anyAdded;
        }
        return anyAdded;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<AnalyticsHttpEvent> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

