/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheManager;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventDispatcher.class);
    private final AnalyticsEventCacheManager cacheManager;

    public AnalyticsEventDispatcher(AnalyticsEventCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void dispatch(AnalyticsHttpEvent event) {
        if (this.isPolicyViolation(event)) {
            this.processPolicyViolation(event);
        } else {
            this.cacheManager.getAvailableRegularCaches().forEach(cache -> {
                if (cache.offer(event)) {
                    LOGGER.trace("Analytics event successfully added to {}. Event details: {}", (Object)cache.getName(), (Object)event);
                } else {
                    LOGGER.trace("Analytics event was not added to {}. Event details: {}", (Object)cache.getName(), (Object)event);
                }
            });
        }
    }

    private void processPolicyViolation(AnalyticsHttpEvent event) {
        this.cacheManager.getAvailablePolicyViolationsCache().forEach(cache -> {
            if (cache.offer(event)) {
                LOGGER.trace("Analytics policy violation event successfully added to {}. Event details: {}", (Object)cache.getName(), (Object)event);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Analytics policy violation event was not added to {}. Threshold was exceeded. Event details: {}", (Object)cache.getName(), (Object)event);
            }
        });
    }

    private boolean isPolicyViolation(AnalyticsHttpEvent event) {
        return event.getPolicyViolation() != null;
    }
}

