/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.model;

import com.mulesoft.mule.runtime.gw.analytics.introspector.HttpRequestAttributesIntrospector;
import com.mulesoft.mule.runtime.gw.analytics.introspector.Introspectors;
import com.mulesoft.mule.runtime.gw.analytics.model.HttpRequestAttributes;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestAttributesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestAttributesFactory.class);
    private final Introspectors<HttpRequestAttributesIntrospector> introspectors = new Introspectors<HttpRequestAttributesIntrospector>(HttpRequestAttributesIntrospector::new);

    public Optional<HttpRequestAttributes> from(TypedValue<Object> attributes) {
        try {
            Object attributesValue = attributes.getValue();
            HttpRequestAttributesIntrospector introspector = this.introspectors.getFor(attributesValue.getClass());
            CaseInsensitiveMultiMap headers = introspector.getHeaders(attributesValue);
            return Optional.of(new HttpRequestAttributes((MultiMap<String, String>)(headers instanceof CaseInsensitiveMultiMap ? headers : new CaseInsensitiveMultiMap((MultiMap)headers)), introspector.getRequestUri(attributesValue), introspector.getMethod(attributesValue), introspector.getRemoteAddress(attributesValue)));
        }
        catch (Exception e) {
            LOGGER.debug("Can not read HTTP request attributes from attributes of type {}", (Object)attributes.getDataType().getType());
            return Optional.empty();
        }
    }
}

