/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.cache;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCache;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCacheFactory;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCaches;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsEventCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsEventCacheManager.class);
    private static final String CACHE_DATA_FILE_EXT = ".p";
    private static final String ANALYTICS_QUEUE_NAME = "events-queue";
    private static final String ANALYTICS_AGENT_QUEUE_NAME = "agent-events-queue";
    private final AnalyticsConfiguration configuration;
    private AnalyticsEventCaches cloudCaches;
    private AnalyticsEventCaches agentCaches;
    private List<AnalyticsEventCache> availableRegularCaches;
    private List<AnalyticsEventCache> availableViolationsCaches;
    private AnalyticsEventCacheFactory eventCacheFactory;
    private DB regularEventsDb;
    private DB violationsEventsDb;

    public AnalyticsEventCacheManager(AnalyticsConfiguration configuration) {
        this.configuration = configuration;
        this.availableRegularCaches = new ArrayList<AnalyticsEventCache>();
        this.availableViolationsCaches = new ArrayList<AnalyticsEventCache>();
    }

    public void initialise() {
        this.regularEventsDb = this.createDb(this.configuration.getAnalyticsCacheFile(), "Regular events queue");
        this.violationsEventsDb = this.createDb(this.configuration.getAnalyticsPolicyViolationsCacheFile(), "Violations events queue");
        this.eventCacheFactory = new AnalyticsEventCacheFactory(this.regularEventsDb, this.violationsEventsDb);
        if (this.configuration.eventsToCloudEnabled().booleanValue()) {
            this.cloudCaches = this.createEventCaches(ANALYTICS_QUEUE_NAME);
        }
        if (this.configuration.isServiceMesh().booleanValue()) {
            this.agentCaches = this.cloudCaches;
        } else if (this.configuration.eventsThroughAgentEnabled().booleanValue()) {
            this.agentCaches = this.createEventCaches(ANALYTICS_AGENT_QUEUE_NAME);
        }
    }

    public void dispose() {
        if (this.regularEventsDb != null) {
            this.regularEventsDb.close();
        }
        if (this.violationsEventsDb != null) {
            this.violationsEventsDb.close();
        }
    }

    public Optional<AnalyticsEventCaches> getCloudCaches() {
        return Optional.ofNullable(this.cloudCaches);
    }

    public Optional<AnalyticsEventCaches> getAgentCaches() {
        return Optional.ofNullable(this.agentCaches);
    }

    public List<AnalyticsEventCache> getAvailableRegularCaches() {
        return this.availableRegularCaches;
    }

    public List<AnalyticsEventCache> getAvailablePolicyViolationsCache() {
        return this.availableViolationsCaches;
    }

    private AnalyticsEventCaches createEventCaches(String queueName) {
        AnalyticsEventCache regularEventCache = this.eventCacheFactory.createRegularEventCache(queueName, this.configuration.getCacheCapacity());
        AnalyticsEventCache policyViolationCache = this.eventCacheFactory.createPolicyViolationsCache(queueName, this.configuration.getPolicyViolationsCacheCapacity(), this.configuration.getPolicyViolationThreshold());
        this.availableRegularCaches.add(regularEventCache);
        this.availableViolationsCaches.add(policyViolationCache);
        return new AnalyticsEventCaches(regularEventCache, policyViolationCache);
    }

    private DB createDb(File cacheFile, String cacheName) {
        DB db;
        try {
            db = this.makeDB(cacheFile);
        }
        catch (Throwable throwable) {
            LOGGER.warn("There was an error attempting to open {}. Resetting it to its factory settings. {}", (Object)cacheName, (Object)throwable);
            FileUtils.deleteQuietly((File)cacheFile);
            FileUtils.deleteQuietly((File)new File(cacheFile.getAbsolutePath() + CACHE_DATA_FILE_EXT));
            db = this.makeDB(cacheFile);
        }
        return db;
    }

    private DB makeDB(File file) {
        return DBMaker.newFileDB((File)file).transactionDisable().mmapFileEnable().asyncWriteEnable().closeOnJvmShutdown().deleteFilesAfterClose().make();
    }
}

