/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient;

import com.mulesoft.mule.runtime.gw.client.httpclient.connection.RestartableConnectionManager;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class GatewayHttpClient
implements HttpClient {
    private final HttpClient httpClient;
    private final RestartableConnectionManager connectionManager;
    private final int timeout;

    public GatewayHttpClient(HttpClient httpClient, RestartableConnectionManager connectionManager, int timeout) {
        this.httpClient = httpClient;
        this.connectionManager = connectionManager;
        this.timeout = timeout;
    }

    public void cleanConnections() {
        this.connectionManager.closeExpiredConnections();
        this.connectionManager.closeIdleConnections(this.timeout, TimeUnit.MILLISECONDS);
    }

    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        try {
            return this.httpClient.execute(request);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        try {
            return this.httpClient.execute(request, context);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        try {
            return this.httpClient.execute(target, request);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        try {
            return this.httpClient.execute(target, request, context);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        try {
            return (T)this.httpClient.execute(request, responseHandler);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        try {
            return (T)this.httpClient.execute(request, responseHandler, context);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        try {
            return (T)this.httpClient.execute(target, request, responseHandler);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        try {
            return (T)this.httpClient.execute(target, request, responseHandler, context);
        }
        catch (IOException | Error e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    public void shutdown() {
        this.connectionManager.shutdown();
    }
}

