/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.function.dispersion;

import java.util.Random;
import java.util.function.Function;

public class RangeDispersant
implements Function<Double, Double> {
    private final double from;
    private final double to;
    private Random random;

    public RangeDispersant(double from, double to) {
        this.from = from;
        this.to = to;
        this.random = new Random();
    }

    @Override
    public Double apply(Double value) {
        return value * (this.random.nextDouble() * this.from + (this.to - this.from));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeDispersant that = (RangeDispersant)o;
        if (Double.compare(that.from, this.from) != 0) {
            return false;
        }
        return Double.compare(that.to, this.to) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.from);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.to);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "RangeDispersant{from=" + this.from + ", to=" + this.to + '}';
    }
}

