/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import com.mulesoft.mule.runtime.gw.internal.encryption.GatewayEncryptionException;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import java.util.Base64;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;

public class DefaultRuntimeEncrypter
extends RuntimeEncrypter {
    private Encrypter encrypter;

    public DefaultRuntimeEncrypter(Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    @Override
    public String encrypt(String valueToEncrypt) throws GatewayEncryptionException {
        if (valueToEncrypt == null || this.containsEncryptionExpression(valueToEncrypt)) {
            return valueToEncrypt;
        }
        try {
            byte[] contentBytes = valueToEncrypt.getBytes();
            byte[] encryptedValue = this.encrypter.encrypt(contentBytes);
            return String.format("%s%s%s", "![", new String(Base64.getEncoder().encode(encryptedValue)), "]");
        }
        catch (MuleEncryptionException e) {
            throw new GatewayEncryptionException("Error trying to encrypt one of the properties", e);
        }
    }

    @Override
    public String decrypt(String valueToDecrypt) throws GatewayEncryptionException {
        if (valueToDecrypt == null || !this.containsEncryptionExpression(valueToDecrypt)) {
            return valueToDecrypt;
        }
        try {
            byte[] contentBytes = this.extractValueFromExpression(valueToDecrypt).getBytes();
            byte[] content = Base64.getDecoder().decode(contentBytes);
            return new String(this.encrypter.decrypt(content));
        }
        catch (MuleEncryptionException e) {
            throw new GatewayEncryptionException("Error trying to decrypt " + valueToDecrypt, e);
        }
    }
}

