/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;
import org.apache.commons.lang3.StringUtils;

public class GateKeeperConfiguration
extends RuntimeConfiguration {
    private static final String GATEKEEPER_MODE = "anypoint.platform.gatekeeper";
    private static final String GATEKEEPER_MODE_DEFAULT = Mode.FLEXIBLE.name();

    public boolean isEnabled() {
        return !this.parsePropertyValue().equals((Object)Mode.DISABLED);
    }

    public Mode mode() {
        return this.parsePropertyValue();
    }

    private Mode parsePropertyValue() {
        String modeInput = StringUtils.trimToNull((String)System.getProperty(GATEKEEPER_MODE, GATEKEEPER_MODE_DEFAULT));
        try {
            return Mode.valueOf(modeInput.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("{} is not a valid GateKeeper configuration mode. Flexible mode will be used", (Object)modeInput);
            return Mode.FLEXIBLE;
        }
    }

    public static enum Mode {
        DISABLED,
        FLEXIBLE,
        STRICT;

    }
}

