/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.httpobjects.filter;

import com.mtvnet.boxspring.httpobjects.HttpServletObjectsHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpServletObjectsHolderFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(HttpServletObjectsHolderFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletRequestHolderFilter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletObjectsHolder.setRequest(httpRequest);
        HttpServletObjectsHolder.setResponse(httpResponse);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound request context to thread: " + request));
        }
        try {
            filterChain.doFilter(request, response);
        }
        finally {
            HttpServletObjectsHolder.setRequest(null);
            HttpServletObjectsHolder.setResponse(null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cleared thread-bound request context: " + request));
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

