/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Color;
import com.mousebird.maply.BaseInfo;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTexture;
import com.mousebird.maply.Scene;
import java.util.ArrayList;

public class StickerInfo
extends BaseInfo {
    static int StickerPriorityDefault = 30000;

    public StickerInfo() {
        this.initialise();
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.setDrawPriority(StickerPriorityDefault);
    }

    public void setColor(int color) {
        this.setColor((float)Color.red((int)color) / 255.0f, (float)Color.green((int)color) / 255.0f, (float)Color.blue((int)color) / 255.0f, (float)Color.alpha((int)color) / 255.0f);
    }

    public native void setColor(float var1, float var2, float var3, float var4);

    public void setImages(ArrayList<MaplyTexture> textures) {
        long[] texIDs = new long[textures.size()];
        int which = 0;
        for (MaplyTexture tex : textures) {
            texIDs[which] = tex.texID;
            ++which;
        }
        this.setImagesNative(texIDs);
    }

    native void setImagesNative(long[] var1);

    public void setShaderName(MaplyBaseController control, String name) {
        this.setShaderName(control.getScene(), name);
    }

    native void setShaderName(Scene var1, String var2);

    public void finalize() {
        this.dispose();
    }

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        StickerInfo.nativeInit();
    }
}

