/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.os.Looper;
import android.util.Log;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyTexture;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import java.util.ArrayList;

public class Shader {
    MaplyBaseController control = null;
    ArrayList<MaplyTexture> textures = new ArrayList();
    private long nativeHandle;
    private long nativeSceneHandle;

    public Shader(String name, String vertexSrc, String fragSrc, MaplyBaseController inControl) {
        this.control = inControl;
        boolean okay = true;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            okay = this.control.setEGLContext(null);
        }
        if (okay) {
            this.initialise(name, vertexSrc, fragSrc);
        } else {
            Log.i((String)"Maply", (String)"Shader was set up before context was created.  Shader won't work.");
        }
    }

    private Shader() {
    }

    public native boolean valid();

    public native String getName();

    public void addTexture(String name, MaplyTexture texture) {
        ChangeSet changes = new ChangeSet();
        this.textures.add(texture);
        this.addTextureNative(changes, name, texture.texID);
        changes.process(this.control.getScene());
    }

    native void addTextureNative(ChangeSet var1, String var2, long var3);

    public boolean setUniform(String name, double uni) {
        MaplyBaseController.ContextInfo context = this.control.setupTempContext(MaplyBaseController.ThreadMode.ThreadCurrent);
        this.control.requestRender();
        boolean ret = this.setUniformNative(name, uni);
        this.control.clearTempContext(context);
        return ret;
    }

    public native boolean setUniformNative(String var1, double var2);

    public boolean setUniform(String name, int uni) {
        MaplyBaseController.ContextInfo context = this.control.setupTempContext(MaplyBaseController.ThreadMode.ThreadCurrent);
        this.control.requestRender();
        boolean ret = this.setUniformNative(name, uni);
        this.control.clearTempContext(context);
        return ret;
    }

    public native boolean setUniformNative(String var1, int var2);

    public boolean setUniform(String name, Point2d pt) {
        MaplyBaseController.ContextInfo context = this.control.setupTempContext(MaplyBaseController.ThreadMode.ThreadCurrent);
        this.control.requestRender();
        boolean ret = this.setUniformNative(name, pt.getX(), pt.getY());
        this.control.clearTempContext(context);
        return ret;
    }

    public boolean setUniform(String name, Point3d pt) {
        MaplyBaseController.ContextInfo context = this.control.setupTempContext(MaplyBaseController.ThreadMode.ThreadCurrent);
        this.control.requestRender();
        boolean ret = this.setUniformNative(name, pt.getX(), pt.getY(), pt.getZ());
        this.control.clearTempContext(context);
        return ret;
    }

    public boolean setUniform(String name, Point4d pt) {
        MaplyBaseController.ContextInfo context = this.control.setupTempContext(MaplyBaseController.ThreadMode.ThreadCurrent);
        this.control.requestRender();
        boolean ret = this.setUniformNative(name, pt.getX(), pt.getY(), pt.getZ(), pt.getW());
        this.control.clearTempContext(context);
        return ret;
    }

    native boolean setUniformNative(String var1, double var2, double var4);

    native boolean setUniformNative(String var1, double var2, double var4, double var6);

    native boolean setUniformNative(String var1, double var2, double var4, double var6, double var8);

    public native long getID();

    private static native void nativeInit();

    native void initialise(String var1, String var2, String var3);

    native void dispose();

    static {
        Shader.nativeInit();
    }
}

