/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.os.Build;
import com.mousebird.maply.GLTextureView;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Scene;
import com.mousebird.maply.View;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.concurrent.Semaphore;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class RendererWrapper
implements GLSurfaceView.Renderer,
GLTextureView.Renderer {
    boolean valid = true;
    public MaplyRenderer maplyRender = null;
    public Scene scene = null;
    public View view = null;
    public MaplyBaseController maplyControl = null;
    public Thread renderThread = null;
    private boolean doScreenshot = false;
    public MaplyBaseController.ScreenshotListener screenshotListener;
    int frameCount = 0;
    Semaphore renderLock = new Semaphore(1, true);
    boolean firstFrame = true;

    public RendererWrapper(MaplyBaseController inMapControl) {
        this.maplyControl = inMapControl;
    }

    public void finalize() {
    }

    public MaplyRenderer getMaplyRender() {
        return this.maplyRender;
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        if (this.valid) {
            this.maplyRender = new MaplyRenderer();
            this.maplyRender.setScene(this.scene);
            this.maplyRender.setView(this.view);
            this.maplyRender.setConfig(config);
            this.renderThread = Thread.currentThread();
            this.maplyControl.surfaceCreated(this);
        }
        this.renderLock.release();
    }

    public void shutdown() {
        this.maplyRender.dispose();
        this.maplyRender = null;
        this.scene = null;
        this.view = null;
        this.maplyControl = null;
        this.renderThread = null;
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        if (this.valid) {
            this.maplyRender.surfaceChanged(width, height);
            this.maplyRender.doRender();
        }
        this.renderLock.release();
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.firstFrame) {
            this.firstFrame = false;
            this.maplyControl.getContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (!(RendererWrapper.this.maplyControl == null || Build.VERSION.SDK_INT <= 16 || RendererWrapper.this.maplyControl.usesTextureView() && Build.VERSION.SDK_INT >= 24)) {
                        RendererWrapper.this.maplyControl.getContentView().setBackground(null);
                    }
                }
            });
        }
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        if (this.valid) {
            this.maplyRender.doRender();
        }
        if (this.doScreenshot) {
            Bitmap screenshot = this.getPixels(0, 0, (int)this.maplyControl.getViewSize().getX(), (int)this.maplyControl.getViewSize().getY(), gl);
            this.screenshotListener.onScreenshotResult(screenshot);
            this.screenshotListener = null;
            this.doScreenshot = false;
        }
        this.renderLock.release();
    }

    private Bitmap getPixels(int x, int y, int w, int h, GL10 gl) {
        int[] b = new int[w * (y + h)];
        int[] bt = new int[w * h];
        IntBuffer ib = IntBuffer.wrap(b);
        ib.position(0);
        gl.glReadPixels(x, 0, w, y + h, 6408, 5121, (Buffer)ib);
        int i = 0;
        int k = 0;
        while (i < h) {
            for (int j = 0; j < w; ++j) {
                int pix1;
                int pix = b[i * w + j];
                int pb = pix >> 16 & 0xFF;
                int pr = pix << 16 & 0xFF0000;
                bt[(h - k - 1) * w + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
            }
            ++i;
            ++k;
        }
        return Bitmap.createBitmap((int[])bt, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public void takeScreenshot(MaplyBaseController.ScreenshotListener listener, GLSurfaceView surfaceView) {
        this.screenshotListener = listener;
        this.doScreenshot = true;
        if (surfaceView != null) {
            surfaceView.requestRender();
        }
    }

    public void stopRendering() {
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        this.valid = false;
        this.renderLock.release();
    }
}

