/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.squareup.okhttp.Request;
import java.net.URL;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteTileInfo {
    public ArrayList<String> baseURLs = new ArrayList();
    public String ext = null;
    public int minZoom = 0;
    public int maxZoom = 0;
    public int pixelsPerSide = 256;
    public boolean replaceURL = false;
    String timeKey = null;

    public RemoteTileInfo(String inBase, String inExt, int inMinZoom, int inMaxZoom) {
        if (inBase.contains("{x}") || inBase.contains("{y}")) {
            this.replaceURL = true;
        }
        this.baseURLs.add(inBase);
        this.ext = inExt;
        this.minZoom = inMinZoom;
        this.maxZoom = inMaxZoom;
    }

    public void setTimeKey(String inTimeKey) {
        this.timeKey = inTimeKey;
    }

    public RemoteTileInfo(JSONObject json) {
        try {
            JSONArray tileSources = json.getJSONArray("tiles");
            for (int ii = 0; ii < tileSources.length(); ++ii) {
                String tileURL = tileSources.getString(ii);
                if (tileURL.contains("{x}") || tileURL.contains("{y}")) {
                    this.replaceURL = true;
                }
                this.baseURLs.add(tileURL);
            }
            this.replaceURL = true;
            this.minZoom = json.getInt("minzoom");
            this.maxZoom = json.getInt("maxzoom");
            this.ext = this.replaceURL ? null : "png";
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public URL buildURL(int x, int y, int level) {
        String url = null;
        url = this.replaceURL ? this.baseURLs.get(x % this.baseURLs.size()).replace("{x}", "" + x).replace("{y}", "" + y).replace("{z}", "" + level) : this.baseURLs.get(x % this.baseURLs.size()) + level + "/" + x + "/" + y;
        if (url != null && this.ext != null) {
            url = url + "." + this.ext;
        }
        URL retURL = null;
        try {
            retURL = new URL(url);
        }
        catch (Exception e) {
            // empty catch block
        }
        return retURL;
    }

    public Request buildRequest(URL url) {
        return new Request.Builder().url(url).build();
    }

    public String buildCacheName(int x, int y, int level) {
        String name = "";
        name = this.timeKey != null ? name + "/" + level + "_" + x + "_" + y + this.timeKey : name + "/" + level + "_" + x + "_" + y;
        if (this.ext != null) {
            name = name + "." + this.ext;
        }
        return name;
    }

    public String buildCacheName(int x, int y, int level, int frame) {
        if (frame == -1) {
            return this.buildCacheName(x, y, level);
        }
        String name = "";
        name = this.timeKey != null ? name + "/" + level + "_" + x + "_" + y + "_" + this.timeKey : name + "/" + level + "_" + x + "_" + y + "_" + frame;
        if (this.ext != null) {
            name = name + "." + this.ext;
        }
        return name;
    }
}

