/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Point2d;

public class QuadTrackerPointReturn {
    int numPts = 0;
    public double[] screenLocs;
    public int[] tileIDs;
    public double[] coordLocs;
    public double[] tileLocs;

    public QuadTrackerPointReturn(int inNumPts) {
        this.numPts = inNumPts;
        this.screenLocs = new double[2 * this.numPts];
        this.tileIDs = new int[3 * this.numPts];
        this.coordLocs = new double[2 * this.numPts];
        this.tileLocs = new double[2 * this.numPts];
    }

    public int getNumPoints() {
        return this.numPts;
    }

    public void setScreenLoc(int which, double screenU, double screenV) {
        this.screenLocs[2 * which] = screenU;
        this.screenLocs[2 * which + 1] = screenV;
    }

    public Point2d getScreenLoc(int which) {
        Point2d screenLoc = new Point2d();
        screenLoc.setValue(this.screenLocs[2 * which], this.screenLocs[2 * which + 1]);
        return screenLoc;
    }

    public MaplyTileID getTileID(int which) {
        MaplyTileID tileID = new MaplyTileID();
        tileID.x = this.tileIDs[3 * which];
        tileID.y = this.tileIDs[3 * which + 1];
        tileID.level = this.tileIDs[3 * which + 2];
        return tileID;
    }

    public Point2d getCoordLoc(int which) {
        Point2d coordLoc = new Point2d();
        coordLoc.setValue(this.coordLocs[2 * which], this.coordLocs[2 * which + 1]);
        return coordLoc;
    }

    public double getCoordLocX(int which) {
        return this.coordLocs[2 * which];
    }

    public double getCoordLocY(int which) {
        return this.coordLocs[2 * which + 1];
    }

    public Point2d getTileLoc(int which) {
        Point2d tileLoc = new Point2d();
        tileLoc.setValue(this.tileLocs[2 * which], this.tileLocs[2 * which + 1]);
        return tileLoc;
    }

    public double getTileLocU(int which) {
        return this.tileLocs[2 * which];
    }

    public double getTileLocV(int which) {
        return this.tileLocs[2 * which + 1];
    }
}

