/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.os.Handler;
import android.os.Looper;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.Layer;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Scene;
import com.mousebird.maply.ViewState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuadPagingLayer
extends Layer
implements LayerThread.ViewWatcherInterface {
    boolean valid = false;
    public MaplyBaseController maplyControl = null;
    public CoordSystem coordSys = null;
    PagingInterface pagingDelegate = null;
    boolean singleLevelLoading = false;
    Handler evalStepHandle = null;
    Runnable evalStepRun = null;
    Map<MaplyTileID, LoadedTile> loadedTiles = new HashMap<MaplyTileID, LoadedTile>();
    private long nativeHandle;

    private QuadPagingLayer() {
    }

    public QuadPagingLayer(MaplyBaseController inMaplyControl, CoordSystem inCoordSys, PagingInterface inDelegate) {
        this.maplyControl = inMaplyControl;
        this.coordSys = inCoordSys;
        this.pagingDelegate = inDelegate;
        ChangeSet changes = new ChangeSet();
        this.initialise(this.coordSys, this.pagingDelegate, changes);
        LayerThread layerThread = this.maplyControl.getLayerThread();
        if (layerThread != null) {
            layerThread.addChanges(changes);
        }
        this.setSimultaneousFetches(8);
    }

    public void finalize() {
        this.dispose();
    }

    public void setSingleLevelLoading(boolean newVal) {
        this.singleLevelLoading = newVal;
        this.nativeSetSingleLevelLoading(newVal);
    }

    @Override
    public float getMinTime() {
        return 0.1f;
    }

    @Override
    public float getMaxLagTime() {
        return 4.0f;
    }

    @Override
    public void startLayer(LayerThread layerThread) {
        super.startLayer(layerThread);
        layerThread.addWatcher(this);
        Point2d ll = new Point2d(this.coordSys.ll.getX(), this.coordSys.ll.getY());
        Point2d ur = new Point2d(this.coordSys.ur.getX(), this.coordSys.ur.getY());
        this.nativeStartLayer(layerThread.scene, layerThread.renderer, ll, ur, 0, this.pagingDelegate.maxZoom());
        this.valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<MaplyTileID, LoadedTile> map = this.loadedTiles;
        synchronized (map) {
            this.valid = false;
            this.cancelEvalStep();
            for (LoadedTile tile : this.loadedTiles.values()) {
                tile.clear(this.maplyControl);
            }
            this.loadedTiles.clear();
            ChangeSet changes = new ChangeSet();
            this.nativeShutdown(changes);
            this.layerThread.addChanges(changes);
            super.shutdown();
        }
        this.dispose();
    }

    @Override
    public void viewUpdated(ViewState viewState) {
        if (!this.valid) {
            return;
        }
        this.nativeViewUpdate(viewState);
        this.scheduleEvalStep();
    }

    void cancelEvalStep() {
        if (!this.valid) {
            return;
        }
        if (this.evalStepHandle != null) {
            this.evalStepHandle.removeCallbacks(this.evalStepRun);
            this.evalStepHandle = null;
            this.evalStepRun = null;
        }
    }

    void scheduleEvalStep() {
        if (!this.valid) {
            return;
        }
        this.cancelEvalStep();
        this.evalStepRun = new Runnable(){

            @Override
            public void run() {
                QuadPagingLayer.this.evalStep();
            }
        };
        this.evalStepHandle = new Handler();
        this.evalStepHandle.post(this.evalStepRun);
    }

    void evalStep() {
        if (!this.valid) {
            return;
        }
        this.evalStepHandle = null;
        this.evalStepRun = null;
        ChangeSet changes = new ChangeSet();
        boolean didSomething = this.nativeEvalStep(changes);
        this.layerThread.addChanges(changes);
        if (didSomething) {
            this.scheduleEvalStep();
        }
    }

    public void refresh() {
        if (!this.valid) {
            return;
        }
        if (Looper.myLooper() != this.layerThread.getLooper()) {
            Handler handle = new Handler();
            handle.post(new Runnable(){

                @Override
                public void run() {
                    QuadPagingLayer.this.refresh();
                }
            });
            return;
        }
        ChangeSet changes = new ChangeSet();
        boolean doEvalStep = this.nativeRefresh(changes);
        this.layerThread.addChanges(changes);
        if (doEvalStep) {
            this.scheduleEvalStep();
        }
    }

    public Mbr boundsForTile(MaplyTileID tileID) {
        Mbr mbr = new Mbr(new Point2d(0.0, 0.0), new Point2d(0.0, 0.0));
        this.boundsForTileNative(tileID.x, tileID.y, tileID.level, mbr.ll, mbr.ur);
        return mbr;
    }

    protected native void boundsForTileNative(int var1, int var2, int var3, Point2d var4, Point2d var5);

    public Mbr geoBoundsForTile(MaplyTileID tileID) {
        Mbr mbr = new Mbr(new Point2d(0.0, 0.0), new Point2d(0.0, 0.0));
        this.geoBoundsForTileNative(tileID.x, tileID.y, tileID.level, mbr.ll, mbr.ur);
        return mbr;
    }

    protected native void geoBoundsForTileNative(int var1, int var2, int var3, Point2d var4, Point2d var5);

    void loadTile(int x, int y, int level) {
        if (!this.valid) {
            return;
        }
        MaplyTileID tileID = new MaplyTileID(x, y, level);
        LoadedTile thisTile = this.findLoadedTile(tileID);
        if (thisTile != null) {
            return;
        }
        thisTile = new LoadedTile(tileID);
        thisTile.isLoading = true;
        thisTile.didLoad = false;
        thisTile.enable = false;
        this.addLoadedTile(thisTile);
        if (tileID.level >= this.pagingDelegate.minZoom()) {
            this.pagingDelegate.startFetchForTile(this, tileID);
        } else {
            this.tileDidLoad(tileID);
        }
    }

    void unloadTile(int x, int y, int level) {
        if (!this.valid) {
            return;
        }
        MaplyTileID tileID = new MaplyTileID(x, y, level);
        LoadedTile tile = this.findLoadedTile(tileID);
        if (tile == null) {
            if (tileID.level >= this.pagingDelegate.minZoom()) {
                this.pagingDelegate.tileDidUnload(tileID);
            }
            return;
        }
        this.removeLoadedTile(tileID);
        tile.clear(this.maplyControl);
        if (tileID.level >= this.pagingDelegate.minZoom()) {
            this.pagingDelegate.tileDidUnload(tileID);
        }
        if (tileID.level >= this.pagingDelegate.minZoom() && !this.singleLevelLoading) {
            this.runTileUpdate(this.parentTile(tileID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadedTile findLoadedTile(MaplyTileID tileID) {
        Map<MaplyTileID, LoadedTile> map = this.loadedTiles;
        synchronized (map) {
            if (!this.valid) {
                return null;
            }
            return this.loadedTiles.get(tileID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoadedTile(LoadedTile tile) {
        Map<MaplyTileID, LoadedTile> map = this.loadedTiles;
        synchronized (map) {
            if (!this.valid) {
                return;
            }
            this.loadedTiles.put(tile.ident, tile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoadedTile(MaplyTileID tileID) {
        Map<MaplyTileID, LoadedTile> map = this.loadedTiles;
        synchronized (map) {
            if (!this.valid) {
                return;
            }
            this.loadedTiles.remove(tileID);
        }
    }

    public void addData(ComponentObject compObj, MaplyTileID tileID) {
        if (!this.valid) {
            return;
        }
        ArrayList<ComponentObject> compObjs = new ArrayList<ComponentObject>();
        compObjs.add(compObj);
        this.addData(compObjs, tileID);
    }

    public void addData(List<ComponentObject> compObjs, MaplyTileID tileID) {
        if (!this.valid) {
            return;
        }
        LoadedTile tile = this.findLoadedTile(tileID);
        if (tile == null) {
            this.maplyControl.removeObjects(compObjs, MaplyBaseController.ThreadMode.ThreadCurrent);
            return;
        }
        tile.addToCompObjs(compObjs);
    }

    MaplyTileID parentTile(MaplyTileID child) {
        if (child.level == 0) {
            return new MaplyTileID(0, 0, 0);
        }
        return new MaplyTileID(child.x / 2, child.y / 2, child.level - 1);
    }

    public void tileDidLoad(final MaplyTileID tileID) {
        if (this.layerThread.getLooper() != Looper.myLooper()) {
            this.layerThread.addTask(new Runnable(){

                @Override
                public void run() {
                    QuadPagingLayer.this.tileDidLoad(tileID);
                }
            }, true);
            return;
        }
        if (!this.valid) {
            return;
        }
        LoadedTile tile = this.findLoadedTile(tileID);
        if (tile != null) {
            tile.isLoading = false;
            tile.didLoad = true;
        }
        if (this.singleLevelLoading) {
            if (tile != null) {
                this.maplyControl.enableObjects(tile.compObjs, MaplyBaseController.ThreadMode.ThreadCurrent);
            }
        } else {
            this.runTileUpdate(this.parentTile(tileID));
        }
        this.layerThread.addTask(new Runnable(){

            @Override
            public void run() {
                QuadPagingLayer.this.nativeTileDidLoad(tileID.x, tileID.y, tileID.level);
                QuadPagingLayer.this.scheduleEvalStep();
            }
        });
    }

    public void tileFailedToLoad(final MaplyTileID tileID) {
        if (this.layerThread.getLooper() != Looper.myLooper()) {
            this.layerThread.addTask(new Runnable(){

                @Override
                public void run() {
                    QuadPagingLayer.this.tileFailedToLoad(tileID);
                }
            });
            return;
        }
        if (!this.valid) {
            return;
        }
        LoadedTile tile = this.findLoadedTile(tileID);
        if (tile != null) {
            tile.clear(this.maplyControl);
            this.removeLoadedTile(tileID);
        }
        if (!this.singleLevelLoading) {
            this.runTileUpdate(this.parentTile(tileID));
        }
        this.layerThread.addTask(new Runnable(){

            @Override
            public void run() {
                QuadPagingLayer.this.nativeTileDidNotLoad(tileID.x, tileID.y, tileID.level);
                QuadPagingLayer.this.scheduleEvalStep();
            }
        });
    }

    void evaluate(LoadedTile tile, boolean enable, ArrayList<ComponentObject> toEnable, ArrayList<ComponentObject> toDisable) {
        if (!this.valid) {
            return;
        }
        LoadedTile[] children = new LoadedTile[4];
        int numChild = 0;
        for (int ix = 0; ix < 2; ++ix) {
            for (int iy = 0; iy < 2; ++iy) {
                MaplyTileID childID = new MaplyTileID(2 * tile.ident.x + ix, 2 * tile.ident.y + iy, tile.ident.level + 1);
                LoadedTile found = this.loadedTiles.get(childID);
                if (found == null || !found.didLoad) continue;
                children[numChild++] = found;
            }
        }
        if (enable) {
            if (numChild == 4) {
                for (LoadedTile child : children) {
                    if (child == null) continue;
                    this.evaluate(child, enable, toEnable, toDisable);
                }
                if (tile.enable) {
                    tile.enable = false;
                    toDisable.addAll(tile.compObjs);
                }
            } else {
                for (LoadedTile child : children) {
                    if (child == null) continue;
                    this.evaluate(child, false, toEnable, toDisable);
                }
                if (!tile.isLoading && !tile.enable) {
                    tile.enable = true;
                    toEnable.addAll(tile.compObjs);
                }
            }
        } else {
            for (LoadedTile child : children) {
                if (child == null) continue;
                this.evaluate(child, false, toEnable, toDisable);
            }
            if (tile.enable) {
                tile.enable = false;
                toDisable.addAll(tile.compObjs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTileUpdate(MaplyTileID topTile) {
        if (!this.valid) {
            return;
        }
        topTile = new MaplyTileID(0, 0, 0);
        ArrayList<ComponentObject> toEnable = new ArrayList<ComponentObject>();
        ArrayList<ComponentObject> toDisable = new ArrayList<ComponentObject>();
        Map<MaplyTileID, LoadedTile> map = this.loadedTiles;
        synchronized (map) {
            if (!this.valid) {
                return;
            }
            LoadedTile found = this.loadedTiles.get(topTile);
            if (found != null) {
                this.evaluate(found, true, toEnable, toDisable);
            }
        }
        if (toEnable.size() > 0) {
            this.maplyControl.enableObjects(toEnable, MaplyBaseController.ThreadMode.ThreadCurrent);
        }
        if (toDisable.size() > 0) {
            this.maplyControl.disableObjects(toDisable, MaplyBaseController.ThreadMode.ThreadCurrent);
        }
    }

    native void nativeShutdown(ChangeSet var1);

    public native void setSimultaneousFetches(int var1);

    public native void setUseTargetZoomLevel(boolean var1);

    public native void nativeSetSingleLevelLoading(boolean var1);

    public native void setMaxTiles(int var1);

    public native void setTileHeightRange(double var1, double var3);

    public native void setUseParentTileBounds(boolean var1);

    public native void setImportance(double var1);

    private static native void nativeInit();

    native void initialise(CoordSystem var1, PagingInterface var2, ChangeSet var3);

    native void dispose();

    native void nativeStartLayer(Scene var1, MaplyRenderer var2, Point2d var3, Point2d var4, int var5, int var6);

    native void nativeViewUpdate(ViewState var1);

    native boolean nativeEvalStep(ChangeSet var1);

    native boolean nativeRefresh(ChangeSet var1);

    native void nativeTileDidLoad(int var1, int var2, int var3);

    native void nativeTileDidNotLoad(int var1, int var2, int var3);

    static {
        QuadPagingLayer.nativeInit();
    }

    class LoadedTile
    implements Comparable<LoadedTile> {
        public MaplyTileID ident = null;
        public boolean isLoading = false;
        public boolean didLoad = false;
        public boolean enable = false;
        public boolean childrenEnable = false;
        ArrayList<ComponentObject> compObjs = new ArrayList();

        LoadedTile(MaplyTileID inIdent) {
            this.ident = inIdent;
        }

        public void addToCompObjs(List<ComponentObject> newCompObjs) {
            this.compObjs.addAll(newCompObjs);
        }

        public void clear(MaplyBaseController maplyControl) {
            maplyControl.removeObjects(this.compObjs, MaplyBaseController.ThreadMode.ThreadCurrent);
            this.compObjs = new ArrayList();
        }

        @Override
        public int compareTo(LoadedTile that) {
            return this.ident.compareTo(that.ident);
        }
    }

    public static interface PagingInterface {
        public int minZoom();

        public int maxZoom();

        public void startFetchForTile(QuadPagingLayer var1, MaplyTileID var2);

        public void tileDidUnload(MaplyTileID var1);
    }
}

