/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.Point2d;

public class Point3d {
    private long nativeHandle;

    public Point3d() {
        this.initialise();
    }

    public Point3d(Point3d that) {
        this.initialise();
        this.setValue(that.getX(), that.getY(), that.getZ());
    }

    public Point3d(double x, double y, double z) {
        this.initialise();
        this.setValue(x, y, z);
    }

    public void finalize() {
        this.dispose();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point3d)) {
            return false;
        }
        Point3d that = (Point3d)obj;
        return this.getX() == that.getX() && this.getY() == that.getY() && this.getZ() == that.getZ();
    }

    public String toString() {
        return "(" + this.getX() + "," + this.getY() + "," + this.getZ() + ")";
    }

    public Point3d addTo(Point3d that) {
        return new Point3d(this.getX() + that.getX(), this.getY() + that.getY(), this.getZ() + that.getZ());
    }

    public Point3d multiplyBy(double t) {
        return new Point3d(this.getX() * t, this.getY() * t, this.getZ() * t);
    }

    public Point3d subtract(Point3d pt1) {
        return new Point3d(this.getX() - pt1.getX(), this.getY() - pt1.getY(), this.getZ() - pt1.getZ());
    }

    public double length() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Point3d normalized() {
        double len = this.length();
        return new Point3d(this.getX() / len, this.getY() / len, this.getZ() / len);
    }

    public void normalize() {
        double len = this.length();
        this.setValue(this.getX() / len, this.getY() / len, this.getZ() / len);
    }

    public double dot(Point3d pt) {
        return this.getX() * pt.getX() + this.getY() * pt.getY() + this.getZ() * pt.getZ();
    }

    public Point2d toPoint2d() {
        return new Point2d(this.getX(), this.getY());
    }

    public native double getX();

    public native double getY();

    public native double getZ();

    public native void setValue(double var1, double var3, double var5);

    public native Point3d cross(Point3d var1);

    public native double norm();

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        Point3d.nativeInit();
    }
}

