/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

public class Point2d {
    private long nativeHandle;

    public Point2d() {
        this.initialise();
    }

    public Point2d(Point2d that) {
        this.initialise();
        this.setValue(that.getX(), that.getY());
    }

    public Point2d(double x, double y) {
        this.initialise();
        this.setValue(x, y);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point2d)) {
            return false;
        }
        Point2d that = (Point2d)obj;
        return this.getX() == that.getX() && this.getY() == that.getY();
    }

    public Point2d addTo(Point2d that) {
        return new Point2d(this.getX() + that.getX(), this.getY() + that.getY());
    }

    public Point2d multiplyBy(double t) {
        return new Point2d(this.getX() * t, this.getY() * t);
    }

    public static Point2d FromDegrees(double lon, double lat) {
        return new Point2d(lon / 180.0 * Math.PI, lat / 180.0 * Math.PI);
    }

    public Point2d toDegrees() {
        return new Point2d(this.getX() / Math.PI * 180.0, this.getY() / Math.PI * 180.0);
    }

    public void finalize() {
        this.dispose();
    }

    public String toString() {
        return "(" + this.getX() + "," + this.getY() + ")";
    }

    public native double getX();

    public native double getY();

    public native void setValue(double var1, double var3);

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        Point2d.nativeInit();
    }
}

