/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.ParticleSystem;
import com.mousebird.maply.ParticleSystemAttribute;

public class ParticleBatch {
    private ParticleSystem partSys;
    private double time;
    private long nativeHandle;

    private ParticleBatch() {
    }

    public ParticleBatch(ParticleSystem partSys) {
        this.initialise();
        this.partSys = partSys;
        this.setBatchSize(this.partSys.getBatchSize());
    }

    public void finalize() {
        this.dispose();
    }

    private native void setBatchSize(int var1);

    public native int getBatchSize();

    public native void addAttributeValues(float[] var1);

    public native void addAttributeValues(char[] var1);

    public boolean addAttribute(String attrName, float[] data) {
        for (ParticleSystemAttribute attr : this.partSys.getAttrs()) {
            if (!attrName.equals(attr.getName())) continue;
            if (data.length * 4 != attr.getSize() * this.getBatchSize()) {
                return false;
            }
            this.addAttributeValues(data);
            return true;
        }
        return false;
    }

    public boolean addAttribute(String attrName, char[] data) {
        for (ParticleSystemAttribute attr : this.partSys.getAttrs()) {
            if (!attrName.equals(attr.getName())) continue;
            if (data.length != attr.getSize() * this.getBatchSize()) {
                return false;
            }
            this.addAttributeValues(data);
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.partSys.getAttrs().length == this.getAttributesValueSize();
    }

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    public native int getAttributesValueSize();

    public ParticleSystem getPartSys() {
        return this.partSys;
    }

    static {
        ParticleBatch.nativeInit();
    }
}

