/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyImageTile;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.QuadImageTileLayer;
import com.mousebird.maply.QuadImageTileLayerInterface;
import com.mousebird.maply.RemoteTileInfo;
import com.mousebird.maply.RemoteTileSource;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;

public class MultiplexTileSource
implements QuadImageTileLayer.TileSource {
    MaplyBaseController controller = null;
    CoordSystem coordSys = null;
    RemoteTileInfo[] sources = null;
    int minZoom = 0;
    int maxZoom = 0;
    int pixelsPerSide = 256;
    OkHttpClient client = null;
    boolean hasPremultiplyOption = false;
    public boolean debugOutput = false;
    public RemoteTileSource.TileSourceDelegate delegate = null;
    HashMap<MaplyTileID, SortedTile> tiles = new HashMap();
    File cacheDir = null;

    public int getDepth() {
        if (this.sources == null) {
            return 0;
        }
        return this.sources.length;
    }

    public MultiplexTileSource(MaplyBaseController inController, RemoteTileInfo[] inSources, CoordSystem inCoordSys) {
        this.controller = inController;
        this.sources = inSources;
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            Class<?> theClass = opts.getClass();
            Field field = theClass.getField("inPremultiplied");
            if (field != null) {
                this.hasPremultiplyOption = true;
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        this.client = this.controller.getHttpClient();
        if (this.sources.length == 0) {
            return;
        }
        this.minZoom = this.sources[0].minZoom;
        this.maxZoom = this.sources[0].maxZoom;
        this.coordSys = inCoordSys;
        for (RemoteTileInfo source : this.sources) {
            this.minZoom = Math.max(source.minZoom, this.minZoom);
            this.maxZoom = Math.min(source.maxZoom, this.maxZoom);
        }
        if (this.minZoom > this.maxZoom) {
            throw new IllegalArgumentException();
        }
    }

    public void setCacheDir(File inCacheDir) {
        this.cacheDir = inCacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFetches(MaplyTileID tileID, int frame) {
        MultiplexTileSource multiplexTileSource = this;
        synchronized (multiplexTileSource) {
            SortedTile tile = this.tiles.get(tileID);
            if (tile != null) {
                tile.cancel(frame);
                if (tile.numActiveFetches() == 0) {
                    this.tiles.remove(tileID);
                }
            }
        }
    }

    public CoordSystem getCoordSystem() {
        return this.coordSys;
    }

    @Override
    public int minZoom() {
        return this.minZoom;
    }

    @Override
    public int maxZoom() {
        return this.maxZoom;
    }

    @Override
    public int pixelsPerSide() {
        return this.pixelsPerSide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFetchForTile(QuadImageTileLayerInterface layer, MaplyTileID tileID, int frame) {
        if (this.debugOutput) {
            Log.d((String)"Maply", (String)("Multiplex Load: " + tileID.level + ": (" + tileID.x + "," + tileID.y + ")" + " " + frame));
        }
        int maxY = 1 << tileID.level;
        int remoteY = maxY - tileID.y - 1;
        HashMap<MaplyTileID, SortedTile> hashMap = this.tiles;
        synchronized (hashMap) {
            int end;
            int start;
            SortedTile tile = this.tiles.get(tileID);
            if (tile == null) {
                tile = new SortedTile(tileID, this.sources.length);
                this.tiles.put(tileID, tile);
            }
            boolean singleFetch = false;
            if (frame == -1) {
                start = 0;
                end = this.sources.length - 1;
            } else {
                start = frame;
                end = frame;
                singleFetch = true;
            }
            for (int which = start; which <= end; ++which) {
                if (tile.fetches[which] != null) continue;
                String cacheFile = null;
                RemoteTileInfo tileInfo = this.sources[which];
                URL tileURL = tileInfo.buildURL(tileID.x, remoteY, tileID.level);
                if (this.cacheDir != null) {
                    cacheFile = this.cacheDir.getAbsolutePath() + tileInfo.buildCacheName(tileID.x, tileID.y, tileID.level, which);
                }
                ConnectionTask task = new ConnectionTask(layer, this, tileID, which, tileURL, cacheFile);
                task.singleFetch = singleFetch;
                tile.fetches[which] = task;
                task.fetchTile();
            }
        }
    }

    class SortedTile
    implements Comparable<SortedTile> {
        MaplyTileID ident = null;
        int depth;
        Bitmap[] tileData = null;
        ConnectionTask[] fetches = null;

        public SortedTile(MaplyTileID inTileID, int inDepth) {
            this.depth = inDepth;
            this.ident = inTileID;
            this.tileData = new Bitmap[this.depth];
            this.fetches = new ConnectionTask[this.depth];
            for (int ii = 0; ii < this.depth; ++ii) {
                this.tileData[ii] = null;
                this.fetches[ii] = null;
            }
        }

        @Override
        public int compareTo(SortedTile that) {
            return this.ident.compareTo(that.ident);
        }

        void cancelAll() {
            for (int ii = 0; ii < this.depth; ++ii) {
                if (this.fetches[ii] != null) {
                    this.fetches[ii].cancel();
                }
                this.fetches[ii] = null;
                this.tileData[ii] = null;
            }
        }

        void cancel(int frame) {
            int which = frame == -1 ? 0 : frame;
            this.clearFetch(frame);
            this.tileData[which] = null;
        }

        void clearFetch(int frame) {
            int which;
            int n = which = frame == -1 ? 0 : frame;
            if (this.fetches[which] != null) {
                this.fetches[which].cancel();
                this.fetches[which] = null;
            }
        }

        boolean isDone() {
            for (Bitmap bm : this.tileData) {
                if (bm != null) continue;
                return false;
            }
            return true;
        }

        void finish(int frame) {
            int which;
            int n = which = frame == -1 ? 0 : frame;
            if (this.fetches[which] != null) {
                this.fetches[which] = null;
            }
        }

        int numActiveFetches() {
            int num = 0;
            for (int ii = 0; ii < this.depth; ++ii) {
                if (this.fetches[ii] == null) continue;
                ++num;
            }
            return num;
        }
    }

    private class ConnectionTask
    implements Callback {
        MultiplexTileSource tileSource = null;
        QuadImageTileLayerInterface layer = null;
        MaplyTileID tileID = null;
        int frame = -1;
        URL url = null;
        String locFile = null;
        Call call;
        Bitmap bm = null;
        File cacheFile = null;
        boolean isCanceled = false;
        public boolean singleFetch = false;

        ConnectionTask(QuadImageTileLayerInterface inLayer, MultiplexTileSource inTileSource, MaplyTileID inTileID, int inFrame, URL inURL, String inFile) {
            this.tileSource = inTileSource;
            this.layer = inLayer;
            this.tileID = inTileID;
            this.locFile = inFile;
            this.frame = inFrame;
            this.url = inURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fetchTile() {
            try {
                if (this.locFile != null) {
                    this.cacheFile = new File(this.locFile);
                    if (this.cacheFile.exists()) {
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inScaled = false;
                        options.inDither = false;
                        options.inPreferQualityOverSpeed = true;
                        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                        if (MultiplexTileSource.this.hasPremultiplyOption) {
                            options.inPremultiplied = false;
                        }
                        BufferedInputStream aBufferedInputStream = new BufferedInputStream(new FileInputStream(this.cacheFile));
                        this.bm = BitmapFactory.decodeStream((InputStream)aBufferedInputStream, null, (BitmapFactory.Options)options);
                        if (MultiplexTileSource.this.debugOutput) {
                            Log.d((String)"Maply", (String)("Read cached file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
                        }
                    }
                }
                if (this.bm != null) {
                    boolean reportThisTile = false;
                    if (this.frame != -1) {
                        SortedTile tile = null;
                        HashMap<MaplyTileID, SortedTile> hashMap = this.tileSource.tiles;
                        synchronized (hashMap) {
                            tile = this.tileSource.tiles.get(this.tileID);
                        }
                        if (tile != null) {
                            tile.tileData[this.frame] = this.bm;
                            if (this.singleFetch || tile.isDone()) {
                                reportThisTile = true;
                            }
                        }
                    } else {
                        reportThisTile = true;
                    }
                    if (reportThisTile) {
                        this.reportTile(true);
                    }
                    return;
                }
                Request request = new Request.Builder().url(this.url).build();
                this.call = MultiplexTileSource.this.client.newCall(request);
                this.call.enqueue((Callback)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onFailure(Request request, IOException e) {
            Log.e((String)"Maply", (String)("Failed to fetch remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " " + this.frame));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(Response response) {
            boolean tileSuccess;
            block19: {
                if (this.isCanceled) {
                    return;
                }
                if (response.code() != 404) {
                    byte[] rawImage = null;
                    try {
                        rawImage = response.body().bytes();
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inScaled = false;
                        options.inDither = false;
                        options.inPreferQualityOverSpeed = true;
                        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                        if (MultiplexTileSource.this.hasPremultiplyOption) {
                            options.inPremultiplied = false;
                        }
                        this.bm = BitmapFactory.decodeByteArray((byte[])rawImage, (int)0, (int)rawImage.length, (BitmapFactory.Options)options);
                        if (this.bm == null) {
                            this.bm = BitmapFactory.decodeByteArray((byte[])rawImage, (int)0, (int)rawImage.length, null);
                            if (this.bm != null && MultiplexTileSource.this.debugOutput) {
                                Log.d((String)"Maply", (String)"Image decode succeeded second time.");
                            }
                        }
                        if (this.cacheFile != null && rawImage != null && this.bm != null) {
                            FileOutputStream fOut = new FileOutputStream(this.cacheFile);
                            ((OutputStream)fOut).write(rawImage);
                            ((OutputStream)fOut).close();
                        }
                        if (MultiplexTileSource.this.debugOutput) {
                            Log.d((String)"Maply", (String)("Fetched remote file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        if (MultiplexTileSource.this.debugOutput) {
                            Log.e((String)"Maply", (String)("Failed to fetch remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " " + this.frame));
                        }
                        break block19;
                    }
                }
                if (MultiplexTileSource.this.debugOutput) {
                    Log.d((String)"Maply", (String)("Fetch failed for remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
                }
            }
            boolean reportThisTile = false;
            boolean bl = tileSuccess = this.bm != null;
            if (this.frame != -1) {
                SortedTile tile = null;
                HashMap<MaplyTileID, SortedTile> hashMap = this.tileSource.tiles;
                synchronized (hashMap) {
                    tile = this.tileSource.tiles.get(this.tileID);
                }
                if (tile != null) {
                    tile.tileData[this.frame] = this.bm;
                    if (this.singleFetch || tile.isDone()) {
                        reportThisTile = true;
                    }
                }
            } else {
                reportThisTile = true;
            }
            if (reportThisTile) {
                this.reportTile(tileSuccess);
            }
        }

        protected void reportTile(final boolean tileSuccess) {
            this.layer.getLayerThread().addTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SortedTile tile = null;
                    HashMap<MaplyTileID, SortedTile> hashMap = ConnectionTask.this.tileSource.tiles;
                    synchronized (hashMap) {
                        tile = ConnectionTask.this.tileSource.tiles.get(ConnectionTask.this.tileID);
                    }
                    boolean removeTile = false;
                    if (tileSuccess && (ConnectionTask.this.singleFetch || tile != null)) {
                        MaplyImageTile imageTile = null;
                        imageTile = ConnectionTask.this.singleFetch ? new MaplyImageTile(ConnectionTask.this.bm) : new MaplyImageTile(tile.tileData);
                        if (ConnectionTask.this.tileSource.delegate != null) {
                            ConnectionTask.this.tileSource.delegate.tileDidLoad(ConnectionTask.this.tileSource, ConnectionTask.this.tileID, ConnectionTask.this.frame);
                        }
                        ConnectionTask.this.layer.loadedTile(ConnectionTask.this.tileID, ConnectionTask.this.frame, imageTile);
                    } else {
                        if (ConnectionTask.this.tileSource.delegate != null) {
                            ConnectionTask.this.tileSource.delegate.tileDidNotLoad(ConnectionTask.this.tileSource, ConnectionTask.this.tileID, ConnectionTask.this.frame);
                        }
                        ConnectionTask.this.layer.loadedTile(ConnectionTask.this.tileID, ConnectionTask.this.frame, null);
                    }
                    if (tile != null) {
                        HashMap<MaplyTileID, SortedTile> hashMap2 = ConnectionTask.this.tileSource.tiles;
                        synchronized (hashMap2) {
                            tile.finish(ConnectionTask.this.frame);
                            removeTile = ConnectionTask.this.singleFetch ? tile.numActiveFetches() == 0 : tile.isDone();
                            if (removeTile) {
                                ConnectionTask.this.tileSource.tiles.remove(tile.ident);
                            }
                        }
                    }
                }
            }, true);
        }

        protected void cancel() {
            this.isCanceled = true;
            if (this.call != null) {
                this.call.cancel();
            }
        }
    }
}

