/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.app.Activity;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.ParticleBatch;
import com.mousebird.maply.ParticleSystem;
import com.mousebird.maply.ParticleSystemAttribute;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Shader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class MaplyStarModel {
    private static final String vertexShaderTriPoint = "uniform mat4  u_mvpMatrix;uniform float u_radius;attribute vec3 a_position;attribute float a_size;varying vec4 v_color;void main(){   v_color = vec4(1.0,1.0,1.0,1.0);   gl_PointSize = a_size;   gl_Position = u_mvpMatrix * vec4(a_position * u_radius,1.0);}";
    private static final String fragmentShaderTriPoint = "precision lowp float;varying vec4      v_color;void main(){  gl_FragColor = v_color;}";
    private static final String fragmentShaderTexTriPoint = "precision lowp float;uniform sampler2D s_baseMap0;varying vec4      v_color;void main(){  gl_FragColor = v_color * texture2D(s_baseMap0, gl_PointCoord);}";
    ArrayList<SingleStar> stars;
    ParticleSystem particleSystem;
    ComponentObject particleSystemObj;
    GlobeController viewC;
    MaplyBaseController.ThreadMode addedMode;
    Bitmap image;
    public static final int SECONDS_IN_DAY = 86400;
    public static final long MILLIS_IN_DAY = 86400000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaplyStarModel(String fileName, String imageName, Activity activity) throws IOException {
        String[] paths;
        AssetManager assetMgr = activity.getAssets();
        InputStream inputStream = null;
        for (String path : paths = assetMgr.list("maplystarmodel")) {
            Matcher m;
            if (path.equals(imageName)) {
                BufferedInputStream bufferedInputStream = null;
                try {
                    inputStream = assetMgr.open("maplystarmodel/" + path);
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    this.image = BitmapFactory.decodeStream((InputStream)bufferedInputStream);
                }
                finally {
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if (!path.equals(fileName)) continue;
            try {
                inputStream = assetMgr.open("maplystarmodel/" + path);
                String stars = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                Pattern p = Pattern.compile("[-]?[0-9]*\\.?[0-9]+");
                m = p.matcher(stars);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.stars = new ArrayList();
            if (m.groupCount() % 3 != 0) continue;
            int i = 0;
            SingleStar s = null;
            block20: while (m.find()) {
                switch (i) {
                    case 0: {
                        s = new SingleStar();
                        s.ra = Float.valueOf(m.group()).floatValue();
                        ++i;
                        continue block20;
                    }
                    case 1: {
                        s.dec = Float.valueOf(m.group()).floatValue();
                        ++i;
                        continue block20;
                    }
                    case 2: {
                        s.mag = Float.valueOf(m.group()).floatValue();
                        this.stars.add(s);
                        i = 0;
                        continue block20;
                    }
                }
            }
        }
    }

    public void addToViewc(GlobeController inViewC, MaplyBaseController.ThreadMode mode) {
        this.viewC = inViewC;
        this.addedMode = mode;
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        double jd = MaplyStarModel.getJulianDateDouble(cal.getTimeInMillis());
        double siderealTime = MaplyStarModel.Greenwich_Mean_Sidereal_Deg(jd);
        Shader shader = new Shader("Star Shader", vertexShaderTriPoint, this.image != null ? fragmentShaderTexTriPoint : fragmentShaderTriPoint, this.viewC);
        shader.setUniform("u_radius", 6.0);
        this.viewC.addShaderProgram(shader, "Star Shader");
        long shaderID = this.viewC.getScene().getProgramIDBySceneName("Star Shader");
        this.particleSystem = new ParticleSystem("Stars");
        this.particleSystem.setParticleSystemType(ParticleSystem.STATE.ParticleSystemPoint);
        this.particleSystem.setLifetime(1.0E20);
        this.particleSystem.setTotalParticles(this.stars.size());
        this.particleSystem.setBatchSize(this.stars.size());
        this.particleSystem.setShaderID(shaderID);
        if (this.image != null) {
            this.particleSystem.addTexture(this.image);
        }
        this.particleSystem.addParticleSystemAttribute("a_position", ParticleSystemAttribute.MaplyShaderAttrType.MAPLY_SHADER_ATTR_TYPE_FLOAT3);
        this.particleSystem.addParticleSystemAttribute("a_size", ParticleSystemAttribute.MaplyShaderAttrType.MAPLY_SHADER_ATTR_TYPE_FLOAT);
        this.particleSystemObj = this.viewC.addParticleSystem(this.particleSystem, this.addedMode);
        float[] posData = new float[this.stars.size() * 3];
        float[] sizeData = new float[this.stars.size()];
        for (int i = 0; i < this.stars.size(); ++i) {
            SingleStar singleStar = this.stars.get(i);
            double starLon = Math.toRadians((double)singleStar.ra - 15.0 * siderealTime);
            double starLat = Math.toRadians(singleStar.dec);
            double z = Math.sin(starLat);
            double rad = Math.sqrt(1.0 - z * z);
            Point3d pt = new Point3d(rad * Math.cos(starLon), rad * Math.sin(starLon), z);
            posData[i * 3] = (float)pt.getX();
            posData[i * 3 + 1] = (float)pt.getY();
            posData[i * 3 + 2] = (float)pt.getZ();
            float mag = (float)(6.0 - (double)singleStar.mag);
            if ((double)mag < 0.0) {
                mag = 0.0f;
            }
            sizeData[i] = mag;
        }
        ParticleBatch batch = new ParticleBatch(this.particleSystem);
        batch.addAttribute("a_position", posData);
        batch.addAttribute("a_size", sizeData);
        this.viewC.addParticleBatch(batch, this.addedMode);
    }

    public void removeFromView() {
        if (this.particleSystemObj != null) {
            this.viewC.removeObject(this.particleSystemObj, this.addedMode);
        }
    }

    public static double Greenwich_Mean_Sidereal_Deg(double mjd) {
        double T = (mjd - 51544.5) / 36525.0;
        double gmst = (280.46061837 + 360.98564736629 * (mjd - 51544.5) + 3.87933E-4 * T * T - T * T * T / 3.871E7) % 360.0;
        if (gmst < 0.0) {
            gmst += 360.0;
        }
        return gmst;
    }

    public static double getJulianDateDouble(long millis) {
        TimeZone timeZone = TimeZone.getDefault();
        millis += (long)timeZone.getOffset(millis);
        int integer = (int)(millis / 86400000L);
        double fraction = (double)(millis % 86400000L) / 8.64E7;
        return (double)(integer += MaplyStarModel.getInteger(2440587, 0.5)) + (fraction += MaplyStarModel.getFraction(2451910, 0.5));
    }

    public static int getInteger(int i, double f) {
        int integer = i;
        int fi = (int)f;
        f -= (double)fi;
        integer += fi;
        if (f < 0.0) {
            --integer;
        }
        return integer;
    }

    public static double getFraction(int i, double f) {
        int fi;
        if ((f -= (double)(fi = (int)f)) < 0.0) {
            f += 1.0;
        }
        return f;
    }

    private class SingleStar {
        float mag;
        float ra;
        float dec;

        private SingleStar() {
        }
    }
}

